/*
 * Decompiled with CFR 0.152.
 */
package org.apache.unomi.rest.endpoints;

import java.util.List;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.FormParam;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import org.apache.cxf.rs.security.cors.CrossOriginResourceSharing;
import org.apache.unomi.api.Metadata;
import org.apache.unomi.api.PartialList;
import org.apache.unomi.api.query.Query;
import org.apache.unomi.api.segments.DependentMetadata;
import org.apache.unomi.api.segments.Scoring;
import org.apache.unomi.api.services.SegmentService;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Produces(value={"application/json"})
@Consumes(value={"application/json"})
@CrossOriginResourceSharing(allowAllOrigins=true, allowCredentials=true)
@Path(value="/scoring")
@Component(service={ScoringServiceEndPoint.class}, property={"osgi.jaxrs.resource=true"})
public class ScoringServiceEndPoint {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)ScoringServiceEndPoint.class.getName());
    @Reference
    private SegmentService segmentService;

    public ScoringServiceEndPoint() {
        LOGGER.info("Initializing scoring service endpoint...");
    }

    public void setSegmentService(SegmentService segmentService) {
        this.segmentService = segmentService;
    }

    @GET
    @Path(value="/")
    public List<Metadata> getScoringMetadatas(@QueryParam(value="offset") @DefaultValue(value="0") int offset, @QueryParam(value="size") @DefaultValue(value="50") int size, @QueryParam(value="sort") String sortBy) {
        return this.segmentService.getScoringMetadatas(offset, size, sortBy).getList();
    }

    @POST
    @Path(value="/query")
    public PartialList<Metadata> getScoringMetadatas(Query query) {
        return this.segmentService.getScoringMetadatas(query);
    }

    @GET
    @Path(value="/{scoringID}")
    public Scoring getScoringDefinition(@PathParam(value="scoringID") String scoringId) {
        return this.segmentService.getScoringDefinition(scoringId);
    }

    @POST
    @Path(value="/")
    public void setScoringDefinition(Scoring scoring) {
        this.segmentService.setScoringDefinition(scoring);
    }

    @PUT
    @Path(value="/{scope}/{scoringID}")
    @Consumes(value={"application/x-www-form-urlencoded"})
    public void createScoringDefinition(@PathParam(value="scope") String scope, @PathParam(value="scoringID") String scoringId, @FormParam(value="scoringName") String scoringName, @FormParam(value="scoringDescription") String scoringDescription) {
        this.segmentService.createScoringDefinition(scope, scoringId, scoringName, scoringDescription);
    }

    @DELETE
    @Path(value="/{scoringID}")
    public DependentMetadata removeScoringDefinition(@PathParam(value="scoringID") String scoringId, @QueryParam(value="validate") boolean validate) {
        return this.segmentService.removeScoringDefinition(scoringId, validate);
    }

    @GET
    @Path(value="/{scoringID}/impacted")
    public DependentMetadata getScoringDependentMetadata(@PathParam(value="scoringID") String scoringId) {
        return this.segmentService.getScoringDependentMetadata(scoringId);
    }

    @Deprecated
    @GET
    @Path(value="/resetQueries")
    public void resetQueries() {
        for (Metadata metadata : this.segmentService.getScoringMetadatas(0, 50, null).getList()) {
            Scoring s = this.segmentService.getScoringDefinition(metadata.getId());
            this.segmentService.setScoringDefinition(s);
        }
    }
}

