/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.support;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Scanner;
import java.util.regex.MatchResult;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.camel.Exchange;
import org.apache.camel.InvalidPayloadException;
import org.apache.camel.language.simple.SimpleLanguage;
import org.apache.camel.support.ExpressionAdapter;
import org.apache.camel.support.RecordableInputStream;
import org.apache.camel.util.IOHelper;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.StringHelper;

public class TokenXMLExpressionIterator
extends ExpressionAdapter {
    private static final Pattern NAMESPACE_PATTERN = Pattern.compile("xmlns(:\\w+|)\\s*=\\s*('[^']+'|\"[^\"]+\")");
    private static final String SCAN_TOKEN_NS_PREFIX_REGEX = "([^:<>]{1,15}?:|)";
    private static final String SCAN_BLOCK_TOKEN_REGEX_TEMPLATE = "<{0}(\\s+[^>]*)?/>|<{0}(\\s+[^>]*)?>(?:(?!(</{0}\\s*>)).)*</{0}\\s*>";
    private static final String SCAN_PARENT_TOKEN_REGEX_TEMPLATE = "<{0}(\\s+[^>]*\\s*)?>";
    private static final String OPTION_WRAP_TOKEN = "<*>";
    protected final String tagToken;
    protected final String inheritNamespaceToken;

    public TokenXMLExpressionIterator(String tagToken, String inheritNamespaceToken) {
        StringHelper.notEmpty(tagToken, "tagToken");
        this.tagToken = tagToken;
        this.inheritNamespaceToken = inheritNamespaceToken;
    }

    protected Iterator<?> createIterator(Exchange exchange, InputStream in, String charset) {
        String inherit;
        String tag = this.tagToken;
        if (SimpleLanguage.hasSimpleFunction(tag)) {
            tag = SimpleLanguage.expression(tag).evaluate(exchange, String.class);
        }
        if ((inherit = this.inheritNamespaceToken) != null && SimpleLanguage.hasSimpleFunction(inherit)) {
            inherit = SimpleLanguage.expression(inherit).evaluate(exchange, String.class);
        }
        if (!tag.startsWith("<")) {
            tag = "<" + tag;
        }
        if (!tag.endsWith(">")) {
            tag = tag + ">";
        }
        if (inherit != null) {
            if (!inherit.startsWith("<")) {
                inherit = "<" + inherit;
            }
            if (!inherit.endsWith(">")) {
                inherit = inherit + ">";
            }
        }
        if (!tag.startsWith("<") || !tag.endsWith(">")) {
            throw new IllegalArgumentException("XML Tag token must be a valid XML tag, was: " + tag);
        }
        if (!(inherit == null || inherit.startsWith("<") && inherit.endsWith(">"))) {
            throw new IllegalArgumentException("Namespace token must be a valid XML token, was: " + inherit);
        }
        XMLTokenIterator iterator = new XMLTokenIterator(tag, inherit, in, charset);
        iterator.init();
        return iterator;
    }

    @Override
    public boolean matches(Exchange exchange) {
        Object value = this.doEvaluate(exchange, true);
        return ObjectHelper.evaluateValuePredicate(value);
    }

    @Override
    public Object evaluate(Exchange exchange) {
        return this.doEvaluate(exchange, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object doEvaluate(Exchange exchange, boolean closeStream) {
        InputStream in = null;
        try {
            in = exchange.getIn().getMandatoryBody(InputStream.class);
            String charset = IOHelper.getCharsetName(exchange);
            Iterator<?> iterator = this.createIterator(exchange, in, charset);
            return iterator;
        }
        catch (InvalidPayloadException e) {
            exchange.setException(e);
            IOHelper.close((Closeable)in);
            Object var5_7 = null;
            return var5_7;
        }
        finally {
            if (closeStream) {
                IOHelper.close((Closeable)in);
            }
        }
    }

    private static String buildXMLTail(String xmlhead) {
        ArrayList<String> tags = new ArrayList<String>();
        int p = 0;
        while (p < xmlhead.length() && (p = xmlhead.indexOf(60, p)) >= 0) {
            char nc = xmlhead.charAt(p + 1);
            if (nc == '?') {
                ++p;
                continue;
            }
            if (nc == '/') {
                ++p;
                tags.remove(tags.size() - 1);
                continue;
            }
            int ep = xmlhead.indexOf(62, p);
            if (xmlhead.charAt(ep - 1) == '/') {
                ++p;
                continue;
            }
            int sp = xmlhead.substring(p, ep).indexOf(32);
            tags.add(xmlhead.substring(p + 1, sp > 0 ? p + sp : ep));
            p = ep;
        }
        StringBuilder sb = new StringBuilder();
        for (int i = tags.size() - 1; i >= 0; --i) {
            sb.append("</").append((String)tags.get(i)).append(">");
        }
        return sb.toString();
    }

    static class XMLTokenIterator
    implements Iterator<Object>,
    Closeable {
        final String tagToken;
        final InputStream in;
        final String charset;
        Scanner scanner;
        Object image;
        private final Pattern tagTokenPattern;
        private final String inheritNamespaceToken;
        private final boolean wrapToken;
        private Pattern inheritNamespaceTokenPattern;
        private String rootTokenNamespaces;
        private String wrapHead;
        private String wrapTail;

        XMLTokenIterator(String tagToken, String inheritNamespaceToken, InputStream in, String charset) {
            this.tagToken = tagToken;
            this.charset = charset;
            this.tagTokenPattern = Pattern.compile(MessageFormat.format(TokenXMLExpressionIterator.SCAN_BLOCK_TOKEN_REGEX_TEMPLATE, TokenXMLExpressionIterator.SCAN_TOKEN_NS_PREFIX_REGEX + tagToken.substring(1, tagToken.length() - 1)), 40);
            this.inheritNamespaceToken = inheritNamespaceToken;
            if (inheritNamespaceToken != null && TokenXMLExpressionIterator.OPTION_WRAP_TOKEN.equals(inheritNamespaceToken)) {
                this.wrapToken = true;
                this.in = new RecordableInputStream(in, charset);
            } else {
                this.wrapToken = false;
                this.in = in;
                if (inheritNamespaceToken != null) {
                    this.inheritNamespaceTokenPattern = Pattern.compile(MessageFormat.format(TokenXMLExpressionIterator.SCAN_PARENT_TOKEN_REGEX_TEMPLATE, TokenXMLExpressionIterator.SCAN_TOKEN_NS_PREFIX_REGEX + inheritNamespaceToken.substring(1, inheritNamespaceToken.length() - 1)), 40);
                }
            }
        }

        void init() {
            this.scanner = new Scanner(this.in, this.charset);
            this.image = this.scanner.hasNext() ? (String)this.next(true) : null;
        }

        String getNext(boolean first) {
            String next;
            if (first && this.inheritNamespaceToken != null && !this.wrapToken) {
                this.rootTokenNamespaces = this.getNamespacesFromNamespaceToken(this.scanner.findWithinHorizon(this.inheritNamespaceTokenPattern, 0));
            }
            if ((next = this.scanner.findWithinHorizon(this.tagTokenPattern, 0)) == null) {
                return null;
            }
            if (first && this.wrapToken) {
                MatchResult mres = this.scanner.match();
                this.wrapHead = ((RecordableInputStream)this.in).getText(mres.start());
                this.wrapTail = TokenXMLExpressionIterator.buildXMLTail(this.wrapHead);
            }
            if (this.inheritNamespaceToken != null && this.rootTokenNamespaces != null) {
                String head = StringHelper.before(next, ">");
                boolean empty = false;
                if (head.endsWith("/")) {
                    head = head.substring(0, head.length() - 1);
                    empty = true;
                }
                StringBuilder sb = new StringBuilder();
                String tail = StringHelper.after(next, ">");
                next = sb.append(head).append(this.rootTokenNamespaces).append(empty ? "/>" : ">").append(tail).toString();
            } else if (this.wrapToken) {
                StringBuilder sb = new StringBuilder();
                next = sb.append(this.wrapHead).append(next).append(this.wrapTail).toString();
            }
            return next;
        }

        private String getNamespacesFromNamespaceToken(String text) {
            if (text == null) {
                return null;
            }
            LinkedHashMap<String, String> namespaces = new LinkedHashMap<String, String>();
            Matcher matcher = NAMESPACE_PATTERN.matcher(text);
            while (matcher.find()) {
                String prefix = matcher.group(1);
                String url = matcher.group(2);
                prefix = ObjectHelper.isEmpty(prefix) ? "_DEFAULT_" : prefix.substring(1);
                namespaces.put(prefix, url);
            }
            if (namespaces.isEmpty()) {
                return null;
            }
            StringBuilder sb = new StringBuilder();
            for (Map.Entry entry : namespaces.entrySet()) {
                String key = (String)entry.getKey();
                String value = (String)entry.getValue();
                if ("_DEFAULT_".equals(key)) {
                    sb.append(" xmlns=").append(value);
                    continue;
                }
                sb.append(" xmlns:").append(key).append("=").append(value);
            }
            return sb.toString();
        }

        @Override
        public boolean hasNext() {
            return this.image != null;
        }

        @Override
        public Object next() {
            return this.next(false);
        }

        Object next(boolean first) {
            Object answer = this.image;
            this.image = this.scanner.hasNext() ? this.getNext(first) : null;
            if (answer == null) {
                answer = this.image;
            }
            return answer;
        }

        @Override
        public void remove() {
        }

        @Override
        public void close() throws IOException {
            this.scanner.close();
        }
    }
}

