/*
 * Decompiled with CFR 0.152.
 */
package org.apache.unomi.shell.migration.service;

import groovy.lang.Script;
import java.io.IOException;
import java.net.URL;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.osgi.framework.Bundle;
import org.osgi.framework.Version;

public class MigrationScript
implements Comparable<MigrationScript> {
    private static final Pattern SCRIPT_FILENAME_PATTERN = Pattern.compile("^migrate-(\\d+.\\d+.\\d+)-(\\d+)-([\\w|.]+).groovy$");
    private final String script;
    private Script compiledScript;
    private final Bundle bundle;
    private final Version version;
    private final int priority;
    private final String name;

    protected MigrationScript(URL scriptURL, Bundle bundle) throws IOException {
        this.bundle = bundle;
        this.script = IOUtils.toString((URL)scriptURL);
        String path = scriptURL.getPath();
        String fileName = StringUtils.substringAfterLast((String)path, (String)"/");
        Matcher m = SCRIPT_FILENAME_PATTERN.matcher(fileName);
        if (!m.find()) {
            throw new IllegalStateException("Migration script file name do not respect the expected format: " + fileName + ". Expected format is: migrate-VERSION-PRIORITY-NAME.groovy. Example: migrate-2.0.0-01-segmentReindex.groovy");
        }
        this.version = new Version(m.group(1));
        this.priority = Integer.parseInt(m.group(2));
        this.name = m.group(3);
    }

    protected Script getCompiledScript() {
        return this.compiledScript;
    }

    protected void setCompiledScript(Script compiledScript) {
        this.compiledScript = compiledScript;
    }

    protected String getScript() {
        return this.script;
    }

    protected Bundle getBundle() {
        return this.bundle;
    }

    protected Version getVersion() {
        return this.version;
    }

    protected int getPriority() {
        return this.priority;
    }

    protected String getName() {
        return this.name;
    }

    public String toString() {
        return "{version=" + this.version + ", name='" + this.name + '\'' + (this.bundle != null ? ", bundle=" + this.bundle.getSymbolicName() : "") + '}';
    }

    @Override
    public int compareTo(MigrationScript other) {
        int result = this.version.compareTo(other.getVersion());
        if (result != 0) {
            return result;
        }
        result = this.priority - other.getPriority();
        if (result != 0) {
            return result;
        }
        return this.name.compareTo(other.getName());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MigrationScript that = (MigrationScript)o;
        return new EqualsBuilder().append(this.priority, that.priority).append((Object)this.version, (Object)that.version).append((Object)this.name, (Object)that.name).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder(17, 37).append((Object)this.version).append(this.priority).append((Object)this.name).toHashCode();
    }
}

