/*
 * Decompiled with CFR 0.152.
 */
package aQute.lib.memoize;

import aQute.lib.memoize.Memoize;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;

class RefreshingMemoizingSupplier<T>
implements Memoize<T> {
    private final Supplier<? extends T> supplier;
    private final long time_to_live;
    private volatile long timebound;
    private T memoized;

    RefreshingMemoizingSupplier(Supplier<? extends T> supplier, long time_to_live, TimeUnit unit) {
        this.supplier = Objects.requireNonNull(supplier);
        this.time_to_live = Objects.requireNonNull(unit).toNanos(time_to_live < 0L ? 0L : time_to_live);
        this.timebound = System.nanoTime();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public T get() {
        long endtime = this.timebound;
        if (System.nanoTime() - endtime >= 0L) {
            RefreshingMemoizingSupplier refreshingMemoizingSupplier = this;
            synchronized (refreshingMemoizingSupplier) {
                if (endtime == this.timebound) {
                    T result = this.supplier.get();
                    this.memoized = result;
                    this.timebound = System.nanoTime() + this.time_to_live;
                    return result;
                }
            }
        }
        return this.memoized;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public T peek() {
        long endtime = this.timebound;
        if (System.nanoTime() - endtime >= 0L) {
            RefreshingMemoizingSupplier refreshingMemoizingSupplier = this;
            synchronized (refreshingMemoizingSupplier) {
                if (endtime == this.timebound) {
                    this.memoized = null;
                    this.timebound = System.nanoTime();
                    return null;
                }
            }
        }
        return this.memoized;
    }
}

