/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.join.aggregations;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.apache.lucene.search.Query;
import org.elasticsearch.join.aggregations.ChildrenToParentAggregator;
import org.elasticsearch.join.aggregations.InternalParent;
import org.elasticsearch.search.aggregations.Aggregator;
import org.elasticsearch.search.aggregations.AggregatorFactories;
import org.elasticsearch.search.aggregations.AggregatorFactory;
import org.elasticsearch.search.aggregations.InternalAggregation;
import org.elasticsearch.search.aggregations.NonCollectingAggregator;
import org.elasticsearch.search.aggregations.pipeline.PipelineAggregator;
import org.elasticsearch.search.aggregations.support.ValuesSource;
import org.elasticsearch.search.aggregations.support.ValuesSourceAggregatorFactory;
import org.elasticsearch.search.aggregations.support.ValuesSourceConfig;
import org.elasticsearch.search.internal.SearchContext;

public class ParentAggregatorFactory
extends ValuesSourceAggregatorFactory<ValuesSource.Bytes.WithOrdinals> {
    private final Query parentFilter;
    private final Query childFilter;

    public ParentAggregatorFactory(String name, ValuesSourceConfig<ValuesSource.Bytes.WithOrdinals> config, Query childFilter, Query parentFilter, SearchContext context, AggregatorFactory parent, AggregatorFactories.Builder subFactoriesBuilder, Map<String, Object> metaData) throws IOException {
        super(name, config, context, parent, subFactoriesBuilder, metaData);
        this.childFilter = childFilter;
        this.parentFilter = parentFilter;
    }

    @Override
    protected Aggregator createUnmapped(Aggregator parent, List<PipelineAggregator> pipelineAggregators, Map<String, Object> metaData) throws IOException {
        return new NonCollectingAggregator(this.name, this.context, parent, pipelineAggregators, metaData){

            @Override
            public InternalAggregation buildEmptyAggregation() {
                return new InternalParent(this.name, 0L, this.buildEmptySubAggregations(), this.pipelineAggregators(), this.metaData());
            }
        };
    }

    @Override
    protected Aggregator doCreateInternal(ValuesSource.Bytes.WithOrdinals valuesSource, Aggregator children, boolean collectsFromSingleBucket, List<PipelineAggregator> pipelineAggregators, Map<String, Object> metaData) throws IOException {
        long maxOrd = valuesSource.globalMaxOrd(this.context.searcher());
        if (collectsFromSingleBucket) {
            return new ChildrenToParentAggregator(this.name, this.factories, this.context, children, this.childFilter, this.parentFilter, valuesSource, maxOrd, pipelineAggregators, metaData);
        }
        return ParentAggregatorFactory.asMultiBucketAggregator(this, this.context, children);
    }
}

