/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.daemon.drpc.webapp;

import jakarta.servlet.Filter;
import jakarta.servlet.FilterChain;
import jakarta.servlet.FilterConfig;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.ws.rs.container.PreMatching;
import jakarta.ws.rs.ext.Provider;
import java.io.IOException;
import org.apache.storm.security.auth.IHttpCredentialsPlugin;
import org.apache.storm.security.auth.ReqContext;

@Provider
@PreMatching
public class ReqContextFilter
implements Filter {
    private final IHttpCredentialsPlugin httpCredsHandler;

    public ReqContextFilter(IHttpCredentialsPlugin httpCredsHandler) {
        this.httpCredsHandler = httpCredsHandler;
    }

    public void populateContext(HttpServletRequest request) {
        if (this.httpCredsHandler != null) {
            this.httpCredsHandler.populateContext(ReqContext.context(), request);
        }
    }

    public void init(FilterConfig config) throws ServletException {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        this.handle((HttpServletRequest)request, (HttpServletResponse)response, chain);
    }

    public void handle(HttpServletRequest request, HttpServletResponse response, FilterChain chain) throws IOException, ServletException {
        if (request != null) {
            this.populateContext(request);
        }
        chain.doFilter((ServletRequest)request, (ServletResponse)response);
    }

    public void destroy() {
    }
}

