/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.metricstore.rocksdb;

import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;

public enum KeyType {
    TOPOLOGY_BLOB(0),
    METADATA_STRING_START(1),
    TOPOLOGY_STRING(1),
    METRIC_STRING(2),
    COMPONENT_STRING(3),
    EXEC_ID_STRING(4),
    HOST_STRING(5),
    STREAM_ID_STRING(6),
    METADATA_STRING_END(7),
    METRIC_DATA(128);

    private static Map<Byte, KeyType> MAP;
    private final byte value;

    private KeyType(int value) {
        this.value = (byte)value;
    }

    static KeyType getKeyType(byte value) {
        KeyType type = MAP.get(value);
        if (type == null) {
            throw new RuntimeException("Invalid key type " + value);
        }
        return type;
    }

    byte getValue() {
        return this.value;
    }

    static {
        MAP = new HashMap<Byte, KeyType>();
        for (KeyType type : EnumSet.allOf(KeyType.class)) {
            MAP.put(type.getValue(), type);
        }
        MAP = Collections.unmodifiableMap(MAP);
    }
}

