/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.metrics2;

import com.codahale.metrics.Counter;
import com.codahale.metrics.Gauge;
import com.codahale.metrics.Histogram;
import com.codahale.metrics.Meter;
import com.codahale.metrics.MetricFilter;
import com.codahale.metrics.ScheduledReporter;
import com.codahale.metrics.Timer;
import java.util.Map;
import java.util.SortedMap;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.storm.metrics2.MetricRegistryProvider;
import org.apache.storm.metrics2.TaskMetricDimensions;
import org.apache.storm.metrics2.TaskMetricRepo;

public class DimensionalReporter
extends ScheduledReporter {
    private ScheduledReporter underlyingReporter;
    private MetricRegistryProvider metricRegistryProvider;
    private MetricFilter filter;
    private DimensionHandler dimensionHandler;

    public DimensionalReporter(MetricRegistryProvider metricRegistryProvider, ScheduledReporter unstartedReporter, DimensionHandler dimensionHandler, String name, MetricFilter filter, TimeUnit rateUnit, TimeUnit durationUnit, ScheduledExecutorService executor, boolean shutdownExecutorOnStop) {
        super(metricRegistryProvider.getRegistry(), name, filter, rateUnit, durationUnit, executor, shutdownExecutorOnStop);
        this.underlyingReporter = unstartedReporter;
        this.metricRegistryProvider = metricRegistryProvider;
        this.filter = filter;
        this.dimensionHandler = dimensionHandler;
    }

    public void report(SortedMap<String, Gauge> gauges, SortedMap<String, Counter> counters, SortedMap<String, Histogram> histograms, SortedMap<String, Meter> meters, SortedMap<String, Timer> timers) {
        this.report();
    }

    public void report() {
        for (Map.Entry<TaskMetricDimensions, TaskMetricRepo> entry : this.metricRegistryProvider.getTaskMetrics().entrySet()) {
            TaskMetricRepo repo = entry.getValue();
            if (this.dimensionHandler != null) {
                TaskMetricDimensions dimensions = entry.getKey();
                this.dimensionHandler.setDimensions(dimensions.getDimensions());
            }
            repo.report(this.underlyingReporter, this.filter);
        }
    }

    public static interface DimensionHandler {
        public void setDimensions(Map<String, String> var1);
    }
}

