/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.shade.org.apache.curator.framework.recipes.cache;

import java.util.Collections;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.apache.storm.shade.org.apache.curator.framework.CuratorFramework;
import org.apache.storm.shade.org.apache.curator.framework.listen.Listenable;
import org.apache.storm.shade.org.apache.curator.framework.listen.StandardListenerManager;
import org.apache.storm.shade.org.apache.curator.framework.recipes.cache.ChildData;
import org.apache.storm.shade.org.apache.curator.framework.recipes.cache.CuratorCache;
import org.apache.storm.shade.org.apache.curator.framework.recipes.cache.CuratorCacheBridge;
import org.apache.storm.shade.org.apache.curator.framework.recipes.cache.CuratorCacheListener;
import org.apache.storm.shade.org.apache.curator.framework.recipes.cache.TreeCache;
import org.apache.storm.shade.org.apache.curator.framework.recipes.cache.TreeCacheEvent;
import org.apache.storm.shade.org.apache.curator.framework.recipes.cache.TreeCacheListener;
import org.apache.storm.shade.org.apache.curator.shaded.com.google.common.collect.Sets;

class CompatibleCuratorCacheBridge
implements CuratorCacheBridge,
TreeCacheListener {
    private final TreeCache cache;
    private final StandardListenerManager<CuratorCacheListener> listenerManager = StandardListenerManager.standard();

    CompatibleCuratorCacheBridge(CuratorFramework client, String path, CuratorCache.Options[] optionsArg, ExecutorService executorService, boolean cacheData) {
        Set options = optionsArg != null ? Sets.newHashSet(optionsArg) : Collections.emptySet();
        TreeCache.Builder builder = TreeCache.newBuilder(client, path).setCacheData(cacheData);
        if (options.contains((Object)CuratorCache.Options.SINGLE_NODE_CACHE)) {
            builder.setMaxDepth(0);
        }
        if (options.contains((Object)CuratorCache.Options.COMPRESSED_DATA)) {
            builder.setDataIsCompressed(true);
        }
        if (executorService != null) {
            builder.setExecutor(executorService);
        }
        this.cache = builder.build();
    }

    @Override
    public void start() {
        try {
            this.cache.getListenable().addListener(this);
            this.cache.start();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void close() {
        this.cache.close();
    }

    @Override
    public boolean isCuratorCache() {
        return false;
    }

    @Override
    public Listenable<CuratorCacheListener> listenable() {
        return this.listenerManager;
    }

    @Override
    public Optional<ChildData> get(String path) {
        return Optional.ofNullable(this.cache.getCurrentData(path));
    }

    @Override
    public int size() {
        return this.cache.size();
    }

    @Override
    public Stream<ChildData> stream() {
        Iterable iterable = this.cache::iterator;
        return StreamSupport.stream(iterable.spliterator(), false);
    }

    @Override
    public void childEvent(CuratorFramework client, TreeCacheEvent event) throws Exception {
        switch (event.getType()) {
            case NODE_ADDED: {
                this.listenerManager.forEach(listener -> listener.event(CuratorCacheListener.Type.NODE_CREATED, null, event.getData()));
                break;
            }
            case NODE_REMOVED: {
                this.listenerManager.forEach(listener -> listener.event(CuratorCacheListener.Type.NODE_DELETED, event.getData(), null));
                break;
            }
            case NODE_UPDATED: {
                this.listenerManager.forEach(listener -> listener.event(CuratorCacheListener.Type.NODE_CHANGED, event.getOldData(), event.getData()));
                break;
            }
            case INITIALIZED: {
                this.listenerManager.forEach(CuratorCacheListener::initialized);
            }
        }
    }
}

