/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.executor.error;

import java.net.UnknownHostException;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.storm.cluster.IStormClusterState;
import org.apache.storm.executor.error.IReportError;
import org.apache.storm.task.WorkerTopologyContext;
import org.apache.storm.utils.ObjectReader;
import org.apache.storm.utils.Time;
import org.apache.storm.utils.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReportError
implements IReportError {
    private static final Logger LOG = LoggerFactory.getLogger(ReportError.class);
    private final Map<String, Object> topoConf;
    private final IStormClusterState stormClusterState;
    private final String stormId;
    private final String componentId;
    private final WorkerTopologyContext workerTopologyContext;
    private int maxPerInterval;
    private int errorIntervalSecs;
    private AtomicInteger intervalStartTime;
    private AtomicInteger intervalErrors;

    public ReportError(Map<String, Object> topoConf, IStormClusterState stormClusterState, String stormId, String componentId, WorkerTopologyContext workerTopologyContext) {
        this.topoConf = topoConf;
        this.stormClusterState = stormClusterState;
        this.stormId = stormId;
        this.componentId = componentId;
        this.workerTopologyContext = workerTopologyContext;
        this.errorIntervalSecs = ObjectReader.getInt(topoConf.get("topology.error.throttle.interval.secs"));
        this.maxPerInterval = ObjectReader.getInt(topoConf.get("topology.max.error.report.per.interval"));
        this.intervalStartTime = new AtomicInteger(Time.currentTimeSecs());
        this.intervalErrors = new AtomicInteger(0);
    }

    @Override
    public void report(Throwable error) {
        LOG.error("Error", error);
        if (Time.deltaSecs(this.intervalStartTime.get()) > this.errorIntervalSecs) {
            this.intervalErrors.set(0);
            this.intervalStartTime.set(Time.currentTimeSecs());
        }
        if (this.intervalErrors.incrementAndGet() <= this.maxPerInterval) {
            try {
                this.stormClusterState.reportError(this.stormId, this.componentId, Utils.hostname(), this.workerTopologyContext.getThisWorkerPort().longValue(), error);
            }
            catch (UnknownHostException e) {
                throw Utils.wrapInRuntime(e);
            }
        }
    }
}

