/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.health.response;

import java.util.Objects;
import org.jspecify.annotations.NonNull;

public final class HealthResponse {
    private final boolean healthy;
    private final @NonNull String message;
    private final @NonNull String contentType;
    private final int status;

    public HealthResponse(boolean healthy, @NonNull String message, @NonNull String contentType, int status) {
        this.healthy = healthy;
        this.message = Objects.requireNonNull(message);
        this.contentType = Objects.requireNonNull(contentType);
        this.status = status;
    }

    public boolean isHealthy() {
        return this.healthy;
    }

    public @NonNull String getMessage() {
        return this.message;
    }

    public @NonNull String getContentType() {
        return this.contentType;
    }

    public int getStatus() {
        return this.status;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof HealthResponse)) {
            return false;
        }
        HealthResponse that = (HealthResponse)o;
        return this.healthy == that.healthy && this.status == that.status && this.message.equals(that.message) && this.contentType.equals(that.contentType);
    }

    public int hashCode() {
        return Objects.hash(this.healthy, this.message, this.contentType, this.status);
    }

    public String toString() {
        return "HealthResponse{healthy=" + this.healthy + ", message='" + this.message + "', contentType='" + this.contentType + "', status=" + this.status + "}";
    }
}

