/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.commons.log.logback.internal.config;

import java.util.Dictionary;
import java.util.Hashtable;
import org.apache.sling.commons.log.logback.internal.LogConfigManager;
import org.apache.sling.commons.log.logback.internal.config.ConfigurationServiceFactory;
import org.apache.sling.commons.log.logback.internal.config.GlobalConfigurator;
import org.apache.sling.commons.log.logback.internal.config.LogWriterManagedServiceFactory;
import org.apache.sling.commons.log.logback.internal.config.LoggerManagedServiceFactory;
import org.jetbrains.annotations.NotNull;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;

public class ConfigAdminSupport {
    private ServiceRegistration<?> loggingConfigurable;
    private ServiceRegistration<?> writerConfigurer;
    private ServiceRegistration<?> configConfigurer;

    public void start(@NotNull BundleContext context, @NotNull LogConfigManager logConfigManager) {
        Hashtable<String, String> props = new Hashtable<String, String>();
        ((Dictionary)props).put("service.vendor", "Apache Software Foundation");
        ((Dictionary)props).put("service.pid", "org.apache.sling.commons.log.LogManager");
        ((Dictionary)props).put("service.description", "LogManager Configuration Admin support");
        this.loggingConfigurable = context.registerService("org.osgi.service.cm.ManagedService", new ConfigurationServiceFactory<GlobalConfigurator>(logConfigManager, GlobalConfigurator::new), props);
        ConfigurationServiceFactory<LogWriterManagedServiceFactory> msf = new ConfigurationServiceFactory<LogWriterManagedServiceFactory>(logConfigManager, LogWriterManagedServiceFactory::new);
        ((Dictionary)props).put("service.pid", "org.apache.sling.commons.log.LogManager.factory.writer");
        ((Dictionary)props).put("service.description", "LogWriter configurator");
        this.writerConfigurer = context.registerService("org.osgi.service.cm.ManagedServiceFactory", msf, props);
        ConfigurationServiceFactory<LoggerManagedServiceFactory> msf2 = new ConfigurationServiceFactory<LoggerManagedServiceFactory>(logConfigManager, LoggerManagedServiceFactory::new);
        ((Dictionary)props).put("service.pid", "org.apache.sling.commons.log.LogManager.factory.config");
        ((Dictionary)props).put("service.description", "Logger configurator");
        this.configConfigurer = context.registerService("org.osgi.service.cm.ManagedServiceFactory", msf2, props);
    }

    public void stop() {
        if (this.loggingConfigurable != null) {
            this.loggingConfigurable.unregister();
            this.loggingConfigurable = null;
        }
        if (this.writerConfigurer != null) {
            this.writerConfigurer.unregister();
            this.writerConfigurer = null;
        }
        if (this.configConfigurer != null) {
            this.configConfigurer.unregister();
            this.configConfigurer = null;
        }
    }
}

