/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.auth.oauth_client.impl;

import com.nimbusds.oauth2.sdk.id.Identifier;
import java.net.URI;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.servlets.SlingAllMethodsServlet;
import org.apache.sling.auth.oauth_client.ClientConnection;
import org.apache.sling.auth.oauth_client.impl.OAuthCallbackServlet;
import org.apache.sling.auth.oauth_client.impl.OAuthCookieValue;
import org.apache.sling.auth.oauth_client.impl.OAuthEntryPointException;
import org.apache.sling.auth.oauth_client.impl.RedirectHelper;
import org.apache.sling.auth.oauth_client.impl.RedirectTarget;
import org.apache.sling.auth.oauth_client.impl.ResolvedConnection;
import org.apache.sling.auth.oauth_client.impl.ResolvedOAuthConnection;
import org.apache.sling.commons.crypto.CryptoService;
import org.apache.sling.servlets.annotations.SlingServletPaths;
import org.jetbrains.annotations.NotNull;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferencePolicyOption;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={Servlet.class}, property={"sling.auth.requirements=/system/sling/oauth/entry-point"})
@SlingServletPaths(value={"/system/sling/oauth/entry-point"})
public class OAuthEntryPointServlet
extends SlingAllMethodsServlet {
    private static final long serialVersionUID = 1L;
    public static final String PATH = "/system/sling/oauth/entry-point";
    private final Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private final Map<String, ClientConnection> connections;
    private final CryptoService cryptoService;

    @Activate
    public OAuthEntryPointServlet(@Reference(policyOption=ReferencePolicyOption.GREEDY) List<ClientConnection> connections, @Reference CryptoService cryptoService) {
        this.connections = connections.stream().collect(Collectors.toMap(ClientConnection::name, Function.identity()));
        this.cryptoService = cryptoService;
    }

    protected void doGet(@NotNull SlingHttpServletRequest request, @NotNull SlingHttpServletResponse response) throws ServletException {
        try {
            String desiredConnectionName = request.getParameter("c");
            if (desiredConnectionName == null) {
                this.logger.debug("Missing mandatory request parameter 'c'");
                response.sendError(400);
                return;
            }
            ClientConnection connection = this.connections.get(desiredConnectionName);
            if (connection == null) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("Client requested unknown connection '{}'; known: '{}'", (Object)desiredConnectionName, this.connections.keySet());
                }
                response.sendError(400);
                return;
            }
            RedirectTarget redirect = this.getAuthenticationRequestUri(connection, request, URI.create(OAuthCallbackServlet.getCallbackUri((HttpServletRequest)request)));
            response.addCookie(redirect.cookie());
            response.sendRedirect(redirect.uri().toString());
        }
        catch (Exception e) {
            throw new OAuthEntryPointException("Internal error", e);
        }
    }

    @NotNull
    private RedirectTarget getAuthenticationRequestUri(@NotNull ClientConnection connection, @NotNull SlingHttpServletRequest request, @NotNull URI callbackUri) throws OAuthEntryPointException {
        ResolvedConnection conn = ResolvedOAuthConnection.resolve(connection);
        String redirect = request.getParameter("redirect");
        this.validateRedirect(redirect);
        String perRequestKey = new Identifier().getValue();
        OAuthCookieValue oAuthCookieValue = new OAuthCookieValue(perRequestKey, connection.name(), redirect);
        return RedirectHelper.buildRedirectTarget(new String[]{PATH}, callbackUri, conn, oAuthCookieValue, this.cryptoService);
    }

    private void validateRedirect(String redirect) throws OAuthEntryPointException {
        if (redirect == null || redirect.isEmpty()) {
            return;
        }
        if (!redirect.startsWith("/")) {
            String message = "Invalid redirect URL: " + redirect;
            throw new OAuthEntryPointException(message, new IllegalArgumentException(message));
        }
    }
}

