/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing.crs;

import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlType;
import java.util.Map;
import javax.measure.Unit;
import javax.measure.quantity.Angle;
import org.apache.sis.io.wkt.Convention;
import org.apache.sis.io.wkt.Formatter;
import org.apache.sis.pending.geoapi.referencing.MissingMethods;
import org.apache.sis.referencing.CRS;
import org.apache.sis.referencing.crs.AbstractCRS;
import org.apache.sis.referencing.crs.AbstractSingleCRS;
import org.apache.sis.referencing.cs.AbstractCS;
import org.apache.sis.referencing.datum.DatumOrEnsemble;
import org.apache.sis.referencing.datum.DefaultDatumEnsemble;
import org.apache.sis.referencing.datum.DefaultGeodeticDatum;
import org.apache.sis.referencing.datum.DefaultPrimeMeridian;
import org.apache.sis.referencing.internal.Legacy;
import org.apache.sis.referencing.internal.shared.AxisDirections;
import org.apache.sis.referencing.internal.shared.ReferencingUtilities;
import org.apache.sis.referencing.internal.shared.WKTUtilities;
import org.apache.sis.util.resources.Errors;
import org.opengis.referencing.IdentifiedObject;
import org.opengis.referencing.ReferenceIdentifier;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.crs.GeodeticCRS;
import org.opengis.referencing.crs.SingleCRS;
import org.opengis.referencing.crs.VerticalCRS;
import org.opengis.referencing.cs.CartesianCS;
import org.opengis.referencing.cs.CoordinateSystem;
import org.opengis.referencing.cs.EllipsoidalCS;
import org.opengis.referencing.cs.SphericalCS;
import org.opengis.referencing.datum.GeodeticDatum;

@XmlType(name="GeodeticCRSType", propOrder={"ellipsoidalCS", "cartesianCS", "sphericalCS", "datum"})
@XmlRootElement(name="GeodeticCRS")
class DefaultGeodeticCRS
extends AbstractSingleCRS<GeodeticDatum>
implements GeodeticCRS {
    private static final long serialVersionUID = -1634312292667977126L;

    DefaultGeodeticCRS(Map<String, ?> properties, GeodeticDatum datum, DefaultDatumEnsemble<GeodeticDatum> ensemble, CoordinateSystem cs) {
        super(properties, GeodeticDatum.class, datum, ensemble, cs);
    }

    DefaultGeodeticCRS(DefaultGeodeticCRS original, ReferenceIdentifier id, AbstractCS cs) {
        super(original, id, cs);
    }

    protected DefaultGeodeticCRS(GeodeticCRS crs) {
        super((SingleCRS)crs);
    }

    static IllegalArgumentException illegalCoordinateSystemType(CoordinateSystem cs) {
        return new IllegalArgumentException(Errors.format((short)66, ReferencingUtilities.getInterface(CoordinateSystem.class, cs)));
    }

    @Override
    public Class<? extends GeodeticCRS> getInterface() {
        return GeodeticCRS.class;
    }

    @Override
    @XmlElement(name="geodeticDatum", required=true)
    public GeodeticDatum getDatum() {
        return (GeodeticDatum)super.getDatum();
    }

    @Override
    AbstractCRS createSameType(AbstractCS cs) {
        return new DefaultGeodeticCRS(this, null, cs);
    }

    @Override
    protected String formatTo(Formatter formatter) {
        boolean isBaseCRS;
        WKTUtilities.appendName(this, formatter, null);
        CoordinateSystem cs = this.getCoordinateSystem();
        Convention convention = formatter.getConvention();
        boolean isWKT1 = convention.majorVersion() == 1;
        boolean isGeographic = cs instanceof EllipsoidalCS;
        if (isWKT1 && isGeographic && cs.getDimension() == 3) {
            SingleCRS first = CRS.getHorizontalComponent(this);
            VerticalCRS second = CRS.getVerticalComponent(this, true);
            if (first != null && second != null) {
                if (AxisDirections.isVertical(cs.getAxis(0).getDirection())) {
                    SingleCRS t = first;
                    first = second;
                    second = t;
                }
                formatter.newLine();
                formatter.append(WKTUtilities.toFormattable((CoordinateReferenceSystem)first));
                formatter.newLine();
                formatter.append(WKTUtilities.toFormattable((CoordinateReferenceSystem)second));
                formatter.newLine();
                return "Compd_CS";
            }
        }
        formatter.newLine();
        this.formatDatum(formatter);
        formatter.newLine();
        Unit<Angle> angularUnit = AxisDirections.getAngularUnit(cs, null);
        DatumOrEnsemble.getPrimeMeridian(this).ifPresent(pm -> {
            if (convention != Convention.WKT2_SIMPLIFIED || pm.getGreenwichLongitude() != 0.0) {
                Unit oldUnit = formatter.addContextualUnit(angularUnit);
                formatter.indent(1);
                formatter.appendFormattable(pm, DefaultPrimeMeridian::castOrCopy);
                formatter.indent(-1);
                formatter.newLine();
                formatter.restoreContextualUnit(angularUnit, oldUnit);
            }
        });
        if (isWKT1) {
            if (!isGeographic) {
                if (cs instanceof CartesianCS) {
                    cs = Legacy.forGeocentricCRS((CartesianCS)cs, true);
                } else {
                    formatter.setInvalidWKT((IdentifiedObject)cs, null);
                }
            }
            isBaseCRS = false;
        } else {
            isBaseCRS = DefaultGeodeticCRS.isBaseCRS(formatter);
        }
        if (!isBaseCRS || convention == Convention.INTERNAL) {
            this.formatCS(formatter, cs, ReferencingUtilities.getUnit(cs), isWKT1);
        } else if (convention.isSimplified()) {
            formatter.append(formatter.toContextualUnit(angularUnit));
        }
        if (isWKT1) {
            return isGeographic ? "GeogCS" : "GeocCS";
        }
        if (isGeographic && convention.supports(Convention.WKT2_2019)) {
            return isBaseCRS ? "BaseGeogCRS" : formatter.shortOrLong("GeogCRS", "GeographicCRS");
        }
        return isBaseCRS ? "BaseGeodCRS" : formatter.shortOrLong("GeodCRS", "GeodeticCRS");
    }

    @Override
    final void formatDatum(Formatter formatter) {
        DefaultGeodeticCRS.formatDatum(formatter, this, this.getDatum(), DefaultGeodeticDatum::castOrCopy, DatumOrEnsemble::asDatum);
    }

    DefaultGeodeticCRS() {
    }

    private void setDatum(GeodeticDatum value) {
        this.setDatum("geodeticDatum", value);
    }

    @XmlElement(name="ellipsoidalCS")
    private EllipsoidalCS getEllipsoidalCS() {
        return this.getCoordinateSystem(EllipsoidalCS.class);
    }

    @XmlElement(name="cartesianCS")
    private CartesianCS getCartesianCS() {
        return this.getCoordinateSystem(CartesianCS.class);
    }

    @XmlElement(name="sphericalCS")
    private SphericalCS getSphericalCS() {
        return this.getCoordinateSystem(SphericalCS.class);
    }

    private void setEllipsoidalCS(EllipsoidalCS cs) {
        super.setCoordinateSystem("ellipsoidalCS", (CoordinateSystem)cs);
    }

    private void setCartesianCS(CartesianCS cs) {
        super.setCoordinateSystem("cartesianCS", (CoordinateSystem)cs);
    }

    private void setSphericalCS(SphericalCS cs) {
        super.setCoordinateSystem("sphericalCS", (CoordinateSystem)cs);
    }

    static {
        MissingMethods.geodeticDatumEnsemble = crs -> crs instanceof DefaultGeodeticCRS ? ((DefaultGeodeticCRS)crs).getDatumEnsemble() : null;
    }
}

