/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.storage.geotiff.base;

import javax.measure.Unit;
import org.apache.sis.measure.Units;

public enum UnitKey {
    LINEAR(2052, 2053, true, true, false, false),
    ANGULAR(2054, 2055, true, false, true, false),
    AZIMUTH(2060, 0, false, false, true, false),
    PROJECTED(3076, 3077, true, true, false, false),
    VERTICAL(4099, 0, true, true, false, false),
    RATIO(0, 0, false, false, false, true),
    NULL(0, 0, false, false, false, false);

    public final short codeKey;
    public final short scaleKey;
    public final boolean isAxis;
    private final boolean linear;
    private final boolean angular;
    private final boolean scalar;

    private UnitKey(short codeKey, short scaleKey, boolean isAxis, boolean linear, boolean angular, boolean scalar) {
        this.codeKey = codeKey;
        this.scaleKey = scaleKey;
        this.isAxis = isAxis;
        this.linear = linear;
        this.angular = angular;
        this.scalar = scalar;
    }

    public static UnitKey ofProjectionParameter(short key) {
        switch (key) {
            case 2057: 
            case 2058: {
                return LINEAR;
            }
            case 3082: 
            case 3083: 
            case 3086: 
            case 3087: 
            case 3090: 
            case 3091: {
                return PROJECTED;
            }
            case 3092: 
            case 3093: {
                return RATIO;
            }
            case 3094: 
            case 3096: {
                return AZIMUTH;
            }
        }
        if (key >= 3078 && key <= 3096) {
            return ANGULAR;
        }
        return NULL;
    }

    public UnitKey validate(Unit<?> unit) {
        if (this.linear && Units.isLinear(unit) || this.angular && Units.isAngular(unit) || this.scalar && Units.isScale(unit)) {
            return this;
        }
        switch (this.ordinal()) {
            case 0: {
                if (!Units.isAngular(unit)) break;
                return ANGULAR;
            }
            case 1: {
                if (!Units.isLinear(unit)) break;
                return LINEAR;
            }
        }
        return null;
    }

    public Unit<?> defaultUnit() {
        if (this.linear) {
            return Units.METRE;
        }
        if (this.angular) {
            return Units.DEGREE;
        }
        if (this.scalar) {
            return Units.UNITY;
        }
        return null;
    }
}

