/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.image.internal.shared;

import java.util.logging.LogRecord;
import org.apache.sis.image.ErrorHandler;

public final class TileErrorHandler {
    public static final TileErrorHandler THROW = new TileErrorHandler(ErrorHandler.THROW, null, null);
    final ErrorHandler handler;
    private final Class<?> sourceClass;
    private final String sourceMethod;

    public TileErrorHandler(ErrorHandler handler, Class<?> sourceClass, String sourceMethod) {
        this.handler = handler;
        this.sourceClass = sourceClass;
        this.sourceMethod = sourceMethod;
    }

    final boolean isThrow() {
        return this.handler == ErrorHandler.THROW;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void publish(ErrorHandler.Report report) {
        ErrorHandler.Report report2 = report;
        synchronized (report2) {
            if (report.isEmpty()) {
                return;
            }
            if (!this.isThrow()) {
                LogRecord record = report.getDescription();
                if (this.sourceClass != null) {
                    record.setSourceClassName(this.sourceClass.getCanonicalName());
                }
                if (this.sourceMethod != null) {
                    record.setSourceMethodName(this.sourceMethod);
                }
                record.setLoggerName("org.apache.sis.raster");
            }
        }
        this.handler.handle(report);
    }

    public static interface Executor {
        public void execute(Runnable var1, TileErrorHandler var2);
    }
}

