/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing.operation.matrix;

import org.apache.sis.referencing.internal.Resources;
import org.apache.sis.referencing.operation.matrix.MatrixSIS;
import org.apache.sis.referencing.operation.matrix.MismatchedMatrixSizeException;
import org.apache.sis.referencing.operation.matrix.NoninvertibleMatrixException;
import org.apache.sis.util.internal.shared.Numerics;
import org.opengis.referencing.operation.Matrix;

public class Matrix1
extends MatrixSIS {
    private static final long serialVersionUID = -4829171016106097031L;
    public static final int SIZE = 1;
    public double m00;

    public Matrix1() {
        this.m00 = 1.0;
    }

    Matrix1(boolean ignore) {
    }

    public Matrix1(double m00) {
        this.m00 = m00;
    }

    public Matrix1(double[] elements) throws IllegalArgumentException {
        this.setElements(elements);
    }

    Matrix1(Matrix matrix) {
        this.m00 = matrix.getElement(0, 0);
    }

    public static Matrix1 castOrCopy(Matrix matrix) throws MismatchedMatrixSizeException {
        if (matrix == null || matrix instanceof Matrix1) {
            return (Matrix1)matrix;
        }
        Matrix1.ensureSizeMatch(1, 1, matrix);
        return new Matrix1(matrix);
    }

    public final int getNumRow() {
        return 1;
    }

    public final int getNumCol() {
        return 1;
    }

    public final double getElement(int row, int column) {
        if (row == 0 && column == 0) {
            return this.m00;
        }
        throw Matrix1.indexOutOfBounds(row, column);
    }

    public final void setElement(int row, int column, double value) {
        if (row != 0 || column != 0) {
            throw Matrix1.indexOutOfBounds(row, column);
        }
        this.m00 = value;
    }

    @Override
    public final double[] getElements() {
        return new double[]{this.m00};
    }

    @Override
    public final void setElements(double[] elements) {
        Matrix1.ensureLengthMatch(1, elements);
        this.m00 = elements[0];
    }

    @Override
    public final boolean isAffine() {
        return this.m00 == 1.0;
    }

    @Override
    public final boolean isIdentity() {
        return this.m00 == 1.0;
    }

    @Override
    public void transpose() {
    }

    @Override
    public double[] multiply(double[] vector) {
        Matrix1.ensureLengthMatch(1, vector);
        return new double[]{this.m00 * vector[0]};
    }

    @Override
    public MatrixSIS inverse() throws NoninvertibleMatrixException {
        if (this.m00 != 0.0) {
            return new Matrix1(1.0 / this.m00);
        }
        throw new NoninvertibleMatrixException(Resources.format((short)63));
    }

    @Override
    public MatrixSIS normalizeColumns() {
        Matrix1 magnitudes = new Matrix1(Math.abs(this.m00));
        this.m00 = Math.signum(this.m00);
        return magnitudes;
    }

    @Override
    public Matrix1 clone() {
        return (Matrix1)super.clone();
    }

    @Override
    public boolean equals(Object object) {
        if (object != null && object.getClass() == this.getClass()) {
            Matrix1 that = (Matrix1)object;
            return Numerics.equals((double)this.m00, (double)that.m00);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return Long.hashCode(Double.doubleToLongBits(this.m00) ^ 0xBCFB568C01624679L);
    }
}

