/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing.internal;

import java.util.NoSuchElementException;
import java.util.Objects;
import org.apache.sis.geometry.GeneralDirectPosition;
import org.apache.sis.referencing.CRS;
import org.apache.sis.referencing.MultiRegisterOperations;
import org.apache.sis.referencing.operation.transform.MathTransforms;
import org.opengis.geometry.DirectPosition;
import org.opengis.geometry.MismatchedDimensionException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.CoordinateOperation;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.Matrix;
import org.opengis.referencing.operation.TransformException;
import org.opengis.util.FactoryException;

public final class PositionTransformer
extends GeneralDirectPosition {
    private final MultiRegisterOperations factory;
    public final CoordinateReferenceSystem defaultCRS;
    private transient CoordinateReferenceSystem lastCRS;
    private transient MathTransform forward;
    private transient MathTransform inverse;

    public PositionTransformer(CoordinateReferenceSystem defaultCRS, CoordinateReferenceSystem targetCRS, MultiRegisterOperations factory) {
        super(targetCRS);
        this.defaultCRS = defaultCRS != null ? defaultCRS : targetCRS;
        this.factory = factory != null ? factory : MultiRegisterOperations.provider();
    }

    @Override
    public void setCoordinateReferenceSystem(CoordinateReferenceSystem targetCRS) throws MismatchedDimensionException {
        super.setCoordinateReferenceSystem(Objects.requireNonNull(targetCRS));
        this.forward = null;
        this.inverse = null;
    }

    private void setSourceCRS(CoordinateReferenceSystem crs) throws TransformException {
        CoordinateOperation operation;
        CoordinateReferenceSystem targetCRS = this.getCoordinateReferenceSystem();
        try {
            operation = this.factory.findCoordinateOperations(crs, targetCRS).iterator().next();
        }
        catch (NoSuchElementException | FactoryException exception) {
            throw new TransformException(exception.getLocalizedMessage(), exception);
        }
        this.forward = operation.getMathTransform();
        this.inverse = null;
        this.lastCRS = crs;
        if (this.forward.isIdentity()) {
            this.forward = null;
        }
    }

    public void transform(double[] point) throws TransformException {
        if (point != null) {
            if (this.lastCRS != this.defaultCRS) {
                this.setSourceCRS(this.defaultCRS);
            }
            if (this.forward != null) {
                this.forward.transform(point, 0, point, 0, 1);
            }
        }
    }

    public DirectPosition transform(DirectPosition position) throws TransformException {
        if (position != null) {
            CoordinateReferenceSystem userCRS = position.getCoordinateReferenceSystem();
            if (userCRS == null) {
                userCRS = this.defaultCRS;
            }
            if (!CRS.equivalent(this.lastCRS, userCRS)) {
                this.setSourceCRS(userCRS);
            }
            if (this.forward != null) {
                return this.forward.transform(position, (DirectPosition)this);
            }
        }
        return position;
    }

    private MathTransform inverse() throws TransformException {
        if (this.inverse == null) {
            if (!CRS.equivalent(this.lastCRS, this.defaultCRS)) {
                this.setSourceCRS(this.defaultCRS);
            }
            this.inverse = this.forward != null ? this.forward.inverse() : MathTransforms.identity(this.getDimension());
        }
        return this.inverse;
    }

    public DirectPosition inverseTransform() throws TransformException {
        return this.inverse().transform((DirectPosition)this, (DirectPosition)new GeneralDirectPosition(this.defaultCRS));
    }

    public Matrix inverseTransform(double[] target) throws TransformException {
        return MathTransforms.derivativeAndTransform(this.inverse(), this.coordinates, 0, target, 0);
    }
}

