/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing;

import java.io.Serializable;
import java.util.Map;
import java.util.Objects;
import org.apache.sis.io.wkt.Convention;
import org.apache.sis.io.wkt.ElementKind;
import org.apache.sis.io.wkt.FormattableObject;
import org.apache.sis.io.wkt.Formatter;
import org.apache.sis.metadata.TitleProperty;
import org.apache.sis.metadata.internal.shared.Identifiers;
import org.apache.sis.metadata.internal.shared.NameMeaning;
import org.apache.sis.metadata.iso.DefaultIdentifier;
import org.apache.sis.metadata.iso.citation.Citations;
import org.apache.sis.util.collection.Containers;
import org.apache.sis.util.internal.shared.Strings;
import org.apache.sis.util.iso.Types;
import org.apache.sis.util.resources.Errors;
import org.opengis.metadata.citation.Citation;
import org.opengis.parameter.ParameterValue;
import org.opengis.referencing.ReferenceIdentifier;
import org.opengis.util.InternationalString;

@TitleProperty(name="code")
public class ImmutableIdentifier
extends FormattableObject
implements ReferenceIdentifier,
Serializable {
    private static final long serialVersionUID = 1804606250548055829L;
    public static final String DESCRIPTION_KEY = "description";
    private final Citation authority;
    private final String code;
    private final String codeSpace;
    private final String version;
    private final InternationalString description;

    public ImmutableIdentifier(ReferenceIdentifier identifier) {
        this.code = identifier.getCode();
        this.codeSpace = identifier.getCodeSpace();
        this.authority = identifier.getAuthority();
        this.version = identifier.getVersion();
        this.description = identifier instanceof DefaultIdentifier ? ((DefaultIdentifier)identifier).getDescription() : null;
        this.validate(null);
    }

    public ImmutableIdentifier(Citation authority, String codeSpace, String code) {
        this(authority, codeSpace, code, null, null);
    }

    public ImmutableIdentifier(Citation authority, String codeSpace, String code, String version, InternationalString description) {
        this.code = code;
        this.codeSpace = codeSpace;
        this.authority = authority;
        this.version = version;
        this.description = description;
        this.validate(null);
    }

    public ImmutableIdentifier(Map<String, ?> properties) throws IllegalArgumentException {
        this.code = Strings.trimOrNull((String)((String)Containers.property(properties, (Object)"code", String.class)));
        this.version = Strings.trimOrNull((String)((String)Containers.property(properties, (Object)"version", String.class)));
        this.description = Types.toInternationalString(properties, (String)DESCRIPTION_KEY);
        Object value = properties.get("authority");
        if (value instanceof String) {
            this.authority = Citations.fromName((String)((String)value));
        } else if (value == null || value instanceof Citation) {
            this.authority = (Citation)value;
        } else {
            throw ImmutableIdentifier.illegalPropertyType(properties, "authority", value);
        }
        value = properties.get("codespace");
        if (value == null) {
            this.codeSpace = Citations.toCodeSpace((Citation)this.authority);
        } else if (value instanceof String) {
            this.codeSpace = Strings.trimOrNull((String)((String)value));
        } else {
            throw ImmutableIdentifier.illegalPropertyType(properties, "codespace", value);
        }
        this.validate(properties);
    }

    private void validate(Map<String, ?> properties) {
        if (Strings.isNullOrEmpty((String)this.code)) {
            boolean missing = this.code == null || properties != null && properties.get("code") == null;
            throw new IllegalArgumentException(Errors.forProperties(properties).getString(missing ? (short)111 : 47, (Object)"code"));
        }
    }

    private static IllegalArgumentException illegalPropertyType(Map<String, ?> properties, String key, Object value) {
        return new IllegalArgumentException(Errors.forProperties(properties).getString((short)73, (Object)key, value.getClass()));
    }

    public static ImmutableIdentifier castOrCopy(ReferenceIdentifier object) {
        if (object == null || object instanceof ImmutableIdentifier) {
            return (ImmutableIdentifier)object;
        }
        return new ImmutableIdentifier(object);
    }

    public Citation getAuthority() {
        return this.authority;
    }

    public String getCode() {
        return this.code;
    }

    public String getCodeSpace() {
        return this.codeSpace;
    }

    public String getVersion() {
        return this.version;
    }

    public InternationalString getDescription() {
        return this.description;
    }

    public int hashCode() {
        int hash = -614609131;
        if (this.code != null) {
            hash ^= this.code.hashCode();
        }
        if (this.codeSpace != null) {
            hash = hash * 31 + this.codeSpace.hashCode();
        }
        return hash;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object != null && object.getClass() == this.getClass()) {
            ImmutableIdentifier that = (ImmutableIdentifier)object;
            return Objects.equals(this.code, that.code) && Objects.equals(this.codeSpace, that.codeSpace) && Objects.equals(this.authority, that.authority) && Objects.equals(this.version, that.version) && Objects.equals(this.description, that.description);
        }
        return false;
    }

    @Override
    protected String formatTo(Formatter formatter) {
        String keyword;
        String code = this.getCode();
        String codeSpace = this.getCodeSpace();
        Citation authority = this.getAuthority();
        if (codeSpace == null) {
            codeSpace = Identifiers.getIdentifier((Citation)authority, (boolean)true);
        }
        if (code == null || codeSpace == null) {
            formatter.setInvalidWKT(this.getClass(), null);
        }
        formatter.append(codeSpace, ElementKind.IDENTIFIER);
        Convention convention = formatter.getConvention();
        if (convention.majorVersion() == 1) {
            keyword = "Authority";
            formatter.append(code, ElementKind.IDENTIFIER);
        } else {
            String urn;
            String citation;
            boolean isRoot;
            keyword = "Id";
            ImmutableIdentifier.appendCode(formatter, code);
            String version = this.getVersion();
            if (version != null) {
                ImmutableIdentifier.appendCode(formatter, version);
            }
            FormattableObject enclosing = formatter.getEnclosingElement(1);
            boolean bl = isRoot = formatter.getEnclosingElement(2) == null;
            if (!(!isRoot && enclosing instanceof ParameterValue || (citation = Identifiers.getIdentifier((Citation)authority, (boolean)false)) == null || citation.equals(codeSpace))) {
                formatter.append(new Cite(citation));
            }
            if (isRoot && enclosing != null && convention != Convention.INTERNAL && (urn = NameMeaning.toURN(enclosing.getClass(), (String)codeSpace, (String)version, (String)code)) != null) {
                formatter.append(new FormattableObject(this){
                    final /* synthetic */ ImmutableIdentifier this$0;
                    {
                        this.this$0 = this$0;
                    }

                    @Override
                    protected String formatTo(Formatter formatter) {
                        formatter.append(urn, null);
                        return "URI";
                    }
                });
            }
        }
        return keyword;
    }

    private static void appendCode(Formatter formatter, String text) {
        if (text != null) {
            long n;
            try {
                n = Long.parseLong(text);
            }
            catch (NumberFormatException e) {
                formatter.append(text, ElementKind.IDENTIFIER);
                return;
            }
            formatter.append(n);
        }
    }

    private static final class Cite
    extends FormattableObject {
        private final String identifier;

        Cite(String identifier) {
            this.identifier = identifier;
        }

        @Override
        protected String formatTo(Formatter formatter) {
            formatter.append(this.identifier, ElementKind.CITATION);
            return "Citation";
        }
    }
}

