/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.storage.base;

import java.time.Year;
import java.time.temporal.Temporal;
import java.util.Collection;
import java.util.Locale;
import java.util.logging.Logger;
import org.apache.sis.metadata.iso.citation.AbstractParty;
import org.apache.sis.metadata.iso.citation.DefaultCitation;
import org.apache.sis.metadata.iso.citation.DefaultCitationDate;
import org.apache.sis.metadata.iso.citation.DefaultResponsibleParty;
import org.apache.sis.metadata.iso.constraint.DefaultLegalConstraints;
import org.apache.sis.storage.base.MetadataBuilder;
import org.apache.sis.storage.base.StoreUtilities;
import org.apache.sis.util.CharSequences;
import org.apache.sis.util.DefaultInternationalString;
import org.apache.sis.util.logging.Logging;
import org.opengis.metadata.citation.Citation;
import org.opengis.metadata.citation.DateType;
import org.opengis.metadata.citation.ResponsibleParty;
import org.opengis.metadata.citation.Role;
import org.opengis.metadata.constraint.Restriction;
import org.opengis.util.InternationalString;

final class LegalSymbols {
    private static final LegalSymbols[] VALUES = new LegalSymbols[]{new LegalSymbols(Restriction.COPYRIGHT, "COPYRIGHT", "(C)", "\u00a9", "All rights reserved"), new LegalSymbols(Restriction.TRADEMARK, "TRADEMARK", "(TM)", "\u2122", "(R)", "\u00ae")};
    private final Restriction restriction;
    private final String[] symbols;

    private LegalSymbols(Restriction restriction, String ... symbols) {
        this.restriction = restriction;
        this.symbols = symbols;
    }

    private static boolean isSpaceOrPunctuation(int c) {
        switch (Character.getType(c)) {
            case 12: 
            case 13: 
            case 14: 
            case 24: {
                return true;
            }
        }
        return false;
    }

    static void parse(Locale locale, String notice, DefaultLegalConstraints constraints) {
        int c;
        int length = notice.length();
        StringBuilder buffer = new StringBuilder(length);
        int year = 0;
        int quoteLevel = 0;
        boolean isCopyright = false;
        boolean wasSeparator = true;
        boolean wasPunctuation = true;
        boolean skipNextChars = true;
        int i = 0;
        block8: while (i < length) {
            boolean isPunctuation;
            c = notice.codePointAt(i);
            int n = Character.charCount(c);
            int quoteChange = 0;
            boolean isSeparator = false;
            switch (Character.getType(c)) {
                case 21: 
                case 29: {
                    quoteChange = 1;
                    skipNextChars = false;
                    isPunctuation = false;
                    break;
                }
                case 22: 
                case 30: {
                    quoteChange = -1;
                    skipNextChars = false;
                    isPunctuation = false;
                    break;
                }
                default: {
                    skipNextChars = false;
                    isPunctuation = false;
                    break;
                }
                case 24: {
                    isPunctuation = true;
                    isSeparator = true;
                    break;
                }
                case 12: 
                case 13: 
                case 14: {
                    isPunctuation = wasPunctuation;
                    isSeparator = true;
                }
            }
            if (wasSeparator && !isSeparator && quoteLevel == 0) {
                for (LegalSymbols r : VALUES) {
                    for (String symbol : r.symbols) {
                        int after;
                        if (!notice.regionMatches(true, i, symbol, 0, symbol.length()) || (after = i + symbol.length()) < length && !LegalSymbols.isSpaceOrPunctuation(notice.codePointAt(after))) continue;
                        isCopyright |= r.restriction == Restriction.COPYRIGHT;
                        constraints.getUseConstraints().add(r.restriction);
                        wasPunctuation = true;
                        skipNextChars = true;
                        i = after;
                        continue block8;
                    }
                }
                if (isCopyright && wasPunctuation && year == 0 && c >= 48 && c <= 57) {
                    int d;
                    int endOfDigits;
                    for (endOfDigits = i + n; endOfDigits < length && (d = notice.codePointAt(endOfDigits)) >= 48 && d <= 57; ++endOfDigits) {
                    }
                    int endOfToken = CharSequences.skipLeadingWhitespaces((CharSequence)notice, (int)endOfDigits, (int)length);
                    if (endOfToken > endOfDigits || LegalSymbols.isSpaceOrPunctuation(notice.codePointAt(endOfToken))) {
                        try {
                            year = Integer.parseInt(notice.substring(i, endOfDigits));
                            if (year >= 1800 && year <= 9999) {
                                skipNextChars = true;
                                i = endOfToken;
                                continue;
                            }
                            year = 0;
                        }
                        catch (NumberFormatException numberFormatException) {
                            // empty catch block
                        }
                    }
                }
            }
            wasPunctuation = isPunctuation;
            wasSeparator = isSeparator;
            quoteLevel += quoteChange;
            if (!skipNextChars && !Character.isIdentifierIgnorable(c)) {
                buffer.appendCodePoint(c);
            }
            i += n;
        }
        for (i = buffer.length(); i > 0 && LegalSymbols.isSpaceOrPunctuation(c = buffer.codePointBefore(i)); i -= Character.charCount(c)) {
        }
        DefaultCitation citation = null;
        if (locale != null) {
            for (Citation c2 : constraints.getReferences()) {
                if (!(c2 instanceof DefaultCitation) || !LegalSymbols.update(c2.getTitle(), locale, notice)) continue;
                citation = (DefaultCitation)c2;
                break;
            }
        }
        if (citation == null) {
            citation = new DefaultCitation(LegalSymbols.i18n(locale, notice));
            constraints.getReferences().add(citation);
        }
        if (year != 0) {
            DefaultCitationDate date = new DefaultCitationDate((Temporal)Year.of(year), DateType.valueOf((String)"IN_FORCE"));
            Collection dates = citation.getDates();
            if (!dates.contains(date)) {
                dates.add(date);
            }
        }
        if (i != 0) {
            buffer.setLength(i);
            String owner = buffer.toString();
            if (locale != null) {
                for (ResponsibleParty cited : citation.getCitedResponsibleParties()) {
                    if (cited.getRole() != Role.OWNER || !(cited instanceof DefaultResponsibleParty)) continue;
                    for (AbstractParty party : ((DefaultResponsibleParty)cited).getParties()) {
                        InternationalString i18n = party.getName();
                        if (CharSequences.startsWith((CharSequence)owner, (CharSequence)i18n.toString(Locale.ENGLISH), (boolean)true)) {
                            return;
                        }
                        if (!LegalSymbols.update(i18n, locale, owner)) continue;
                        return;
                    }
                }
            }
            AbstractParty party = new AbstractParty(LegalSymbols.i18n(locale, owner), null);
            DefaultResponsibleParty cited = new DefaultResponsibleParty(Role.OWNER);
            cited.getParties().add(party);
            citation.getCitedResponsibleParties().add(cited);
        }
    }

    private static boolean update(InternationalString i18n, Locale locale, String text) {
        if (i18n instanceof DefaultInternationalString) {
            try {
                ((DefaultInternationalString)i18n).add(locale, text);
                return true;
            }
            catch (IllegalArgumentException e) {
                Logging.ignorableException((Logger)StoreUtilities.LOGGER, MetadataBuilder.class, (String)"parseLegalNotice", (Throwable)e);
            }
        }
        return i18n != null && text.equalsIgnoreCase(i18n.toString());
    }

    private static CharSequence i18n(Locale locale, String text) {
        return locale != null ? new DefaultInternationalString(locale, text) : text;
    }
}

