/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.util.resources;

import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import org.apache.sis.util.AbstractInternationalString;
import org.apache.sis.util.Utilities;
import org.apache.sis.util.resources.IndexedResourceBundle;
import org.apache.sis.util.resources.KeyConstants;

public abstract class ResourceInternationalString
extends AbstractInternationalString
implements Serializable {
    private static final long serialVersionUID = -3910920973710535739L;
    private transient short key;
    private final boolean hasArguments;
    private final Object arguments;

    protected ResourceInternationalString(short key) {
        this.key = key;
        this.hasArguments = false;
        this.arguments = null;
    }

    protected ResourceInternationalString(short key, Object arguments) {
        this.key = key;
        this.hasArguments = true;
        this.arguments = arguments;
    }

    protected abstract KeyConstants getKeyConstants();

    protected abstract IndexedResourceBundle getBundle(Locale var1);

    public final LogRecord toLogRecord(Level level) {
        IndexedResourceBundle resources = this.getBundle(null);
        LogRecord record = resources.createLogRecord(level, this.key);
        if (this.hasArguments) {
            record.setParameters(resources.toArray(this.arguments));
        }
        return record;
    }

    @Override
    public final String toString(Locale locale) throws MissingResourceException {
        IndexedResourceBundle resources = this.getBundle(locale);
        return this.hasArguments ? resources.getString(this.key, this.arguments) : resources.getString(this.key);
    }

    public final boolean equals(Object object) {
        if (object == null || object.getClass() != this.getClass()) {
            return false;
        }
        ResourceInternationalString that = (ResourceInternationalString)object;
        return this.key == that.key && this.hasArguments == that.hasArguments && Objects.deepEquals(this.arguments, that.arguments);
    }

    public final int hashCode() {
        return this.getClass().hashCode() ^ this.key + 31 * Utilities.deepHashCode(this.arguments) ^ 0x695BD3C5;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        out.writeUTF(this.getKeyConstants().getKeyName(this.key));
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        try {
            this.key = this.getKeyConstants().getKeyValue(in.readUTF());
        }
        catch (ReflectiveOperationException cause) {
            throw (InvalidObjectException)new InvalidObjectException(cause.toString()).initCause(cause);
        }
    }
}

