/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.proxy.processor.channel;

import com.google.common.base.MoreObjects;
import io.netty.channel.Channel;
import io.netty.channel.ChannelId;
import org.apache.rocketmq.proxy.processor.channel.ChannelExtendAttributeGetter;
import org.apache.rocketmq.proxy.processor.channel.ChannelProtocolType;
import org.apache.rocketmq.proxy.processor.channel.RemoteChannelConverter;
import org.apache.rocketmq.proxy.processor.channel.RemoteChannelSerializer;
import org.apache.rocketmq.proxy.service.channel.SimpleChannel;

public class RemoteChannel
extends SimpleChannel
implements ChannelExtendAttributeGetter {
    protected final ChannelProtocolType type;
    protected final String remoteProxyIp;
    protected volatile String extendAttribute;

    public RemoteChannel(String remoteProxyIp, String remoteAddress, String localAddress, ChannelProtocolType type, String extendAttribute) {
        super(null, new RemoteChannelId(remoteProxyIp, remoteAddress, localAddress, type), remoteAddress, localAddress);
        this.type = type;
        this.remoteProxyIp = remoteProxyIp;
        this.extendAttribute = extendAttribute;
    }

    @Override
    public boolean isWritable() {
        return false;
    }

    public ChannelProtocolType getType() {
        return this.type;
    }

    public String encode() {
        return RemoteChannelSerializer.toJson(this);
    }

    public static RemoteChannel decode(String data) {
        return RemoteChannelSerializer.decodeFromJson(data);
    }

    public static RemoteChannel create(Channel channel) {
        if (channel instanceof RemoteChannelConverter) {
            return ((RemoteChannelConverter)channel).toRemoteChannel();
        }
        return null;
    }

    public String getRemoteProxyIp() {
        return this.remoteProxyIp;
    }

    public void setExtendAttribute(String extendAttribute) {
        this.extendAttribute = extendAttribute;
    }

    @Override
    public String getChannelExtendAttribute() {
        return this.extendAttribute;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("channelId", (Object)this.id()).add("type", (Object)this.type).add("remoteProxyIp", (Object)this.remoteProxyIp).add("extendAttribute", (Object)this.extendAttribute).toString();
    }

    public static class RemoteChannelId
    implements ChannelId {
        private final String id;

        public RemoteChannelId(String remoteProxyIp, String remoteAddress, String localAddress, ChannelProtocolType type) {
            this.id = remoteProxyIp + "@" + remoteAddress + "@" + localAddress + "@" + (Object)((Object)type);
        }

        public String asShortText() {
            return this.id;
        }

        public String asLongText() {
            return this.id;
        }

        public int compareTo(ChannelId o) {
            return this.id.compareTo(o.asLongText());
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("id", (Object)this.id).toString();
        }
    }
}

