/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.plugin;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.apache.qpid.server.plugin.Pluggable;
import org.apache.qpid.server.plugin.QpidServiceLoader;

public class PluggableFactoryLoader<T extends Pluggable> {
    private final Map<String, T> _factoriesMap;
    private final Set<String> _types;

    public PluggableFactoryLoader(Class<T> factoryClass) {
        HashMap<String, Pluggable> fm = new HashMap<String, Pluggable>();
        QpidServiceLoader qpidServiceLoader = new QpidServiceLoader();
        Iterable<T> factories = qpidServiceLoader.atLeastOneInstanceOf(factoryClass);
        for (Pluggable factory : factories) {
            String descriptiveType = factory.getType();
            if (fm.containsKey(descriptiveType)) {
                throw new IllegalStateException(factoryClass.getSimpleName() + " with type name '" + descriptiveType + "' is already registered using class '" + ((Pluggable)fm.get(descriptiveType)).getClass().getName() + "', can not register class '" + factory.getClass().getName() + "'");
            }
            fm.put(descriptiveType, factory);
        }
        this._factoriesMap = Collections.unmodifiableMap(fm);
        this._types = Collections.unmodifiableSortedSet(new TreeSet<String>(this._factoriesMap.keySet()));
    }

    public T get(String type) {
        return (T)((Pluggable)this._factoriesMap.get(type));
    }

    public Set<String> getSupportedTypes() {
        return this._types;
    }
}

