/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.filter;

import org.apache.qpid.server.filter.AMQPFilterTypes;
import org.apache.qpid.server.filter.Filterable;
import org.apache.qpid.server.filter.MessageFilter;

public final class ArrivalTimeFilter
implements MessageFilter {
    private final long _startingFrom;
    private final boolean _startAtTail;

    public ArrivalTimeFilter(long startingFrom, boolean startAtTail) {
        this._startingFrom = startingFrom;
        this._startAtTail = startAtTail;
    }

    @Override
    public String getName() {
        return AMQPFilterTypes.REPLAY_PERIOD.toString();
    }

    @Override
    public boolean startAtTail() {
        return this._startAtTail;
    }

    @Override
    public boolean matches(Filterable message) {
        return message.getArrivalTime() >= this._startingFrom;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ArrivalTimeFilter that = (ArrivalTimeFilter)o;
        return this._startingFrom == that._startingFrom;
    }

    public int hashCode() {
        return (int)(this._startingFrom ^ this._startingFrom >>> 32);
    }

    public String toString() {
        return "ArrivalTimeFilter[startingFrom=" + this._startingFrom + ", startAtTail=" + this._startAtTail + "]";
    }
}

