/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.utilint;

import com.sleepycat.je.dbi.EnvironmentImpl;
import com.sleepycat.je.utilint.LoggerUtils;
import java.util.logging.Handler;
import java.util.logging.LogRecord;

public class ConfiguredRedirectHandler
extends Handler {
    @Override
    public void publish(LogRecord record) {
        Handler h = this.getEnvSpecificConfiguredHandler();
        if (h != null && h.isLoggable(record)) {
            h.publish(record);
        }
    }

    private Handler getEnvSpecificConfiguredHandler() {
        EnvironmentImpl envImpl = LoggerUtils.envMap.get(Thread.currentThread());
        if (envImpl == null) {
            return null;
        }
        return envImpl.getConfiguredHandler();
    }

    @Override
    public void close() throws SecurityException {
        Handler h = this.getEnvSpecificConfiguredHandler();
        if (h != null) {
            h.close();
        }
    }

    @Override
    public void flush() {
        Handler h = this.getEnvSpecificConfiguredHandler();
        if (h != null) {
            h.flush();
        }
    }
}

