/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.formats;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import opennlp.tools.doccat.DocumentSample;
import opennlp.tools.tokenize.Tokenizer;
import opennlp.tools.util.ObjectStream;

public class TwentyNewsgroupSampleStream
implements ObjectStream<DocumentSample> {
    private final Tokenizer tokenizer;
    private final Map<Path, String> catFileMap = new HashMap<Path, String>();
    private Iterator<Map.Entry<Path, String>> catFileTupleIterator;

    TwentyNewsgroupSampleStream(Tokenizer tokenizer, Path dataDir) throws IOException {
        this.tokenizer = tokenizer;
        for (Path dir : Files.newDirectoryStream(dataDir, x$0 -> Files.isDirectory(x$0, new LinkOption[0]))) {
            for (Path file : Files.newDirectoryStream(dir)) {
                this.catFileMap.put(file, dir.getFileName().toString());
            }
        }
        this.reset();
    }

    public DocumentSample read() throws IOException {
        if (this.catFileTupleIterator.hasNext()) {
            Map.Entry<Path, String> catFileTuple = this.catFileTupleIterator.next();
            String text = new String(Files.readAllBytes(catFileTuple.getKey()));
            return new DocumentSample(catFileTuple.getValue(), this.tokenizer.tokenize(text));
        }
        return null;
    }

    public void reset() throws IOException, UnsupportedOperationException {
        this.catFileTupleIterator = this.catFileMap.entrySet().iterator();
    }
}

