/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.util.model;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import opennlp.tools.ml.model.MaxentModel;
import opennlp.tools.postag.POSModel;
import opennlp.tools.util.Version;
import opennlp.tools.util.model.ArtifactSerializer;
import opennlp.tools.util.model.UncloseableInputStream;

public class POSModelSerializer
implements ArtifactSerializer<POSModel> {
    public POSModel create(InputStream in) throws IOException {
        POSModel posModel = new POSModel(new UncloseableInputStream(in));
        Version version = posModel.getVersion();
        if (version.getMajor() == 1 && version.getMinor() == 5 && posModel.getManifestProperty("BeamSize") == null) {
            HashMap<String, String> manifestInfoEntries = new HashMap<String, String>();
            manifestInfoEntries.put("OpenNLP-Version", "1.5.0");
            posModel = new POSModel(posModel.getLanguage(), (MaxentModel)posModel.getArtifact("pos.model"), 10, manifestInfoEntries, posModel.getFactory());
        }
        return posModel;
    }

    public void serialize(POSModel artifact, OutputStream out) throws IOException {
        artifact.serialize(out);
    }
}

