/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.odata2.core;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import org.apache.olingo.odata2.api.exception.ODataBadRequestException;
import org.apache.olingo.odata2.api.exception.ODataException;
import org.apache.olingo.odata2.api.exception.ODataNotAcceptableException;
import org.apache.olingo.odata2.api.processor.ODataRequest;
import org.apache.olingo.odata2.core.commons.ContentType;
import org.apache.olingo.odata2.core.uri.UriInfoImpl;
import org.apache.olingo.odata2.core.uri.UriType;

public class ContentNegotiator {
    private static final String URI_INFO_FORMAT_JSON = "json";
    private static final String URI_INFO_FORMAT_ATOM = "atom";
    private static final String URI_INFO_FORMAT_XML = "xml";
    static final String DEFAULT_CHARSET = "utf-8";

    public ContentType doContentNegotiation(ODataRequest odataRequest, UriInfoImpl uriInfo, List<String> supportedContentTypes) throws ODataException {
        this.validateNotNull(odataRequest, uriInfo, supportedContentTypes);
        if (uriInfo.isCount()) {
            return ContentType.TEXT_PLAIN_CS_UTF_8;
        }
        if (uriInfo.isValue()) {
            if (uriInfo.getUriType() == UriType.URI5 || uriInfo.getUriType() == UriType.URI4) {
                return ContentType.TEXT_PLAIN_CS_UTF_8;
            }
            return this.doContentNegotiationForAcceptHeader(Arrays.asList("*/*"), ContentType.create(supportedContentTypes));
        }
        if (uriInfo.getFormat() == null) {
            return this.doContentNegotiationForAcceptHeader(odataRequest.getAcceptHeaders(), ContentType.create(supportedContentTypes));
        }
        return this.doContentNegotiationForFormat(uriInfo, ContentType.createAsCustom(supportedContentTypes));
    }

    private void validateNotNull(ODataRequest odataRequest, UriInfoImpl uriInfo, List<String> supportedContentTypes) {
        if (uriInfo == null) {
            throw new IllegalArgumentException("Parameter uriInfo MUST NOT be null.");
        }
        if (odataRequest == null) {
            throw new IllegalArgumentException("Parameter odataRequest MUST NOT be null.");
        }
        if (supportedContentTypes == null) {
            throw new IllegalArgumentException("Parameter supportedContentTypes MUST NOT be null.");
        }
    }

    private ContentType doContentNegotiationForFormat(UriInfoImpl uriInfo, List<ContentType> supportedContentTypes) throws ODataException {
        this.validateFormatQuery(uriInfo);
        ContentType formatContentType = this.mapFormat(uriInfo);
        formatContentType = this.ensureCharset(formatContentType);
        for (ContentType contentType : supportedContentTypes) {
            if (!contentType.equals(formatContentType)) continue;
            return formatContentType;
        }
        throw new ODataNotAcceptableException(ODataNotAcceptableException.NOT_SUPPORTED_CONTENT_TYPE.addContent(new Object[]{uriInfo.getFormat()}));
    }

    private void validateFormatQuery(UriInfoImpl uriInfo) throws ODataBadRequestException {
        if (uriInfo.isValue()) {
            throw new ODataBadRequestException(ODataBadRequestException.INVALID_SYNTAX);
        }
    }

    private ContentType mapFormat(UriInfoImpl uriInfo) {
        String format = uriInfo.getFormat();
        if (URI_INFO_FORMAT_XML.equals(format)) {
            return ContentType.APPLICATION_XML;
        }
        if (URI_INFO_FORMAT_ATOM.equals(format)) {
            if (uriInfo.getUriType() == UriType.URI0) {
                return ContentType.APPLICATION_ATOM_SVC;
            }
            if (uriInfo.getUriType() == UriType.URI1) {
                return ContentType.APPLICATION_ATOM_XML_FEED;
            }
            if (uriInfo.getUriType() == UriType.URI2 || uriInfo.getUriType() == UriType.URI10) {
                return ContentType.APPLICATION_ATOM_XML_ENTRY;
            }
        } else if (URI_INFO_FORMAT_JSON.equals(format)) {
            return ContentType.APPLICATION_JSON;
        }
        return ContentType.createAsCustom(format);
    }

    private ContentType doContentNegotiationForAcceptHeader(List<String> acceptHeaderContentTypes, List<ContentType> supportedContentTypes) throws ODataException {
        return this.contentNegotiation(this.extractAcceptHeaders(acceptHeaderContentTypes), supportedContentTypes);
    }

    private List<ContentType> extractAcceptHeaders(List<String> acceptHeaderValues) throws ODataBadRequestException {
        ArrayList<ContentType> mediaTypes = new ArrayList<ContentType>();
        if (acceptHeaderValues != null) {
            for (String mediaType : acceptHeaderValues) {
                try {
                    mediaTypes.add(ContentType.create(mediaType.toString()));
                }
                catch (IllegalArgumentException e) {
                    throw new ODataBadRequestException(ODataBadRequestException.INVALID_HEADER.addContent(new Object[]{"Accept"}).addContent(new Object[]{mediaType.toString()}), (Throwable)e);
                }
            }
        }
        return mediaTypes;
    }

    ContentType contentNegotiation(List<ContentType> acceptedContentTypes, List<ContentType> supportedContentTypes) throws ODataException {
        HashSet<ContentType> setSupported = new HashSet<ContentType>(supportedContentTypes);
        if (acceptedContentTypes.isEmpty()) {
            if (!setSupported.isEmpty()) {
                return supportedContentTypes.get(0);
            }
        } else {
            for (ContentType contentType : acceptedContentTypes) {
                ContentType match = (contentType = this.ensureCharset(contentType)).match(supportedContentTypes);
                if (match == null) continue;
                return match;
            }
        }
        throw new ODataNotAcceptableException(ODataNotAcceptableException.NOT_SUPPORTED_ACCEPT_HEADER.addContent(new Object[]{acceptedContentTypes.toString()}));
    }

    private ContentType ensureCharset(ContentType contentType) {
        if (ContentType.APPLICATION_ATOM_XML.isCompatible(contentType) || ContentType.APPLICATION_ATOM_SVC.isCompatible(contentType) || ContentType.APPLICATION_XML.isCompatible(contentType)) {
            return contentType.receiveWithCharsetParameter(DEFAULT_CHARSET);
        }
        return contentType;
    }
}

