/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.odata2.jpa.processor.core.model;

import java.util.ArrayList;
import java.util.List;
import org.apache.olingo.odata2.api.edm.provider.EntityContainer;
import org.apache.olingo.odata2.jpa.processor.api.access.JPAEdmBuilder;
import org.apache.olingo.odata2.jpa.processor.api.exception.ODataJPAModelException;
import org.apache.olingo.odata2.jpa.processor.api.exception.ODataJPARuntimeException;
import org.apache.olingo.odata2.jpa.processor.api.model.JPAEdmAssociationSetView;
import org.apache.olingo.odata2.jpa.processor.api.model.JPAEdmBaseView;
import org.apache.olingo.odata2.jpa.processor.api.model.JPAEdmEntityContainerView;
import org.apache.olingo.odata2.jpa.processor.api.model.JPAEdmEntitySetView;
import org.apache.olingo.odata2.jpa.processor.api.model.JPAEdmSchemaView;
import org.apache.olingo.odata2.jpa.processor.core.access.model.JPAEdmNameBuilder;
import org.apache.olingo.odata2.jpa.processor.core.model.JPAEdmAssociationSet;
import org.apache.olingo.odata2.jpa.processor.core.model.JPAEdmBaseViewImpl;
import org.apache.olingo.odata2.jpa.processor.core.model.JPAEdmEntitySet;

public class JPAEdmEntityContainer
extends JPAEdmBaseViewImpl
implements JPAEdmEntityContainerView {
    private JPAEdmEntitySetView entitySetView;
    private JPAEdmSchemaView schemaView;
    private JPAEdmAssociationSetView associationSetView;
    private EntityContainer currentEntityContainer;
    private List<EntityContainer> consistentEntityContainerList;

    public JPAEdmEntityContainer(JPAEdmSchemaView view) {
        super((JPAEdmBaseView)view);
        this.schemaView = view;
    }

    public JPAEdmBuilder getBuilder() {
        if (this.builder == null) {
            this.builder = new JPAEdmEntityContainerBuilder();
        }
        return this.builder;
    }

    public EntityContainer getEdmEntityContainer() {
        return this.currentEntityContainer;
    }

    public List<EntityContainer> getConsistentEdmEntityContainerList() {
        return this.consistentEntityContainerList;
    }

    public JPAEdmEntitySetView getJPAEdmEntitySetView() {
        return this.entitySetView;
    }

    public JPAEdmAssociationSetView getEdmAssociationSetView() {
        return this.associationSetView;
    }

    @Override
    public void clean() {
        super.clean();
        this.entitySetView = null;
        this.associationSetView = null;
        this.currentEntityContainer = null;
        this.consistentEntityContainerList = null;
    }

    private class JPAEdmEntityContainerBuilder
    implements JPAEdmBuilder {
        private JPAEdmEntityContainerBuilder() {
        }

        public void build() throws ODataJPAModelException, ODataJPARuntimeException {
            JPAEdmEntityContainer.this.currentEntityContainer = new EntityContainer();
            if (JPAEdmEntityContainer.this.consistentEntityContainerList == null) {
                JPAEdmEntityContainer.this.currentEntityContainer.setDefaultEntityContainer(true);
                JPAEdmEntityContainer.this.consistentEntityContainerList = new ArrayList<EntityContainer>();
            }
            JPAEdmEntityContainer.this.entitySetView = new JPAEdmEntitySet(JPAEdmEntityContainer.this.schemaView);
            JPAEdmEntityContainer.this.entitySetView.getBuilder().build();
            if (!JPAEdmEntityContainer.this.entitySetView.isConsistent()) {
                JPAEdmEntityContainer.this.isConsistent = false;
                return;
            }
            JPAEdmEntityContainer.this.currentEntityContainer.setEntitySets(JPAEdmEntityContainer.this.entitySetView.getConsistentEdmEntitySetList());
            if (!JPAEdmEntityContainer.this.schemaView.getJPAEdmAssociationView().isConsistent()) {
                JPAEdmEntityContainer.this.schemaView.getJPAEdmAssociationView().getBuilder().build();
            }
            JPAEdmEntityContainer.this.associationSetView = new JPAEdmAssociationSet(JPAEdmEntityContainer.this.schemaView);
            JPAEdmEntityContainer.this.associationSetView.getBuilder().build();
            if (!JPAEdmEntityContainer.this.associationSetView.isConsistent()) {
                JPAEdmEntityContainer.this.isConsistent = false;
                return;
            }
            JPAEdmEntityContainer.this.currentEntityContainer.setAssociationSets(JPAEdmEntityContainer.this.associationSetView.getConsistentEdmAssociationSetList());
            JPAEdmNameBuilder.build(JPAEdmEntityContainer.this);
            JPAEdmEntityContainer.this.consistentEntityContainerList.add(JPAEdmEntityContainer.this.currentEntityContainer);
            JPAEdmEntityContainer.this.isConsistent = true;
        }
    }
}

