/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.toolkit.cli.impl.command.nifi.flow;

import java.io.IOException;
import java.util.Properties;
import org.apache.commons.cli.MissingOptionException;
import org.apache.nifi.flow.VersionedReportingTaskSnapshot;
import org.apache.nifi.toolkit.cli.api.CommandException;
import org.apache.nifi.toolkit.cli.api.Context;
import org.apache.nifi.toolkit.cli.impl.command.CommandOption;
import org.apache.nifi.toolkit.cli.impl.command.nifi.AbstractNiFiCommand;
import org.apache.nifi.toolkit.cli.impl.result.nifi.VersionedReportingTaskSnapshotResult;
import org.apache.nifi.toolkit.client.NiFiClient;
import org.apache.nifi.toolkit.client.NiFiClientException;

public class ExportReportingTask
extends AbstractNiFiCommand<VersionedReportingTaskSnapshotResult> {
    public ExportReportingTask() {
        super("export-reporting-task", VersionedReportingTaskSnapshotResult.class);
    }

    @Override
    public void doInitialize(Context context) {
        this.addOption(CommandOption.RT_ID.createOption());
        this.addOption(CommandOption.OUTPUT_FILE.createOption());
    }

    @Override
    public String getDescription() {
        return "Exports a snapshot of the specified reporting task and any management controller services used by the reporting task.  The --" + CommandOption.OUTPUT_FILE.getLongName() + " can be used to export to a file, otherwise the content will be written to terminal or standard out.";
    }

    @Override
    public VersionedReportingTaskSnapshotResult doExecute(NiFiClient client, Properties properties) throws NiFiClientException, IOException, MissingOptionException, CommandException {
        String reportingTaskId = this.getRequiredArg(properties, CommandOption.RT_ID);
        VersionedReportingTaskSnapshot snapshot = client.getFlowClient().getReportingTaskSnapshot(reportingTaskId);
        String outputFile = properties.containsKey(CommandOption.OUTPUT_FILE.getLongName()) ? properties.getProperty(CommandOption.OUTPUT_FILE.getLongName()) : null;
        return new VersionedReportingTaskSnapshotResult(snapshot, outputFile);
    }
}

