/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.web.api.dto;

import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.xml.bind.annotation.XmlType;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.nifi.web.api.dto.BundleDTO;
import org.apache.nifi.web.api.dto.ComponentDTO;
import org.apache.nifi.web.api.dto.ProcessorConfigDTO;
import org.apache.nifi.web.api.dto.RelationshipDTO;

@XmlType(name="processor")
public class ProcessorDTO
extends ComponentDTO {
    public static final String VALID = "VALID";
    public static final String INVALID = "INVALID";
    public static final String VALIDATING = "VALIDATING";
    private String name;
    private String type;
    private BundleDTO bundle;
    private String state;
    private Map<String, String> style;
    private List<RelationshipDTO> relationships;
    private String description;
    private Boolean supportsParallelProcessing;
    private Boolean supportsBatching;
    private Boolean supportsSensitiveDynamicProperties;
    private Boolean persistsState;
    private Boolean restricted;
    private Boolean deprecated;
    private Boolean isExtensionMissing;
    private Boolean executionNodeRestricted;
    private Boolean multipleVersionsAvailable;
    private String inputRequirement;
    private String physicalState;
    private ProcessorConfigDTO config;
    private Collection<String> validationErrors;
    private String validationStatus;

    @Schema(description="The name of the processor.")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Schema(description="The type of the processor.")
    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    @Schema(description="The details of the artifact that bundled this processor type.")
    public BundleDTO getBundle() {
        return this.bundle;
    }

    public void setBundle(BundleDTO bundle) {
        this.bundle = bundle;
    }

    @Schema(description="The state of the processor", allowableValues={"RUNNING", "STOPPED", "DISABLED", "RUN_ONCE"})
    public String getState() {
        return this.state;
    }

    public void setState(String state) {
        this.state = state;
    }

    @Schema(description="Styles for the processor (background-color : #eee).")
    public Map<String, String> getStyle() {
        return this.style;
    }

    public void setStyle(Map<String, String> style) {
        this.style = style;
    }

    @Schema(description="Whether the processor supports parallel processing.")
    public Boolean getSupportsParallelProcessing() {
        return this.supportsParallelProcessing;
    }

    public void setSupportsParallelProcessing(Boolean supportsParallelProcessing) {
        this.supportsParallelProcessing = supportsParallelProcessing;
    }

    @Schema(description="Whether the processor supports sensitive dynamic properties.")
    public Boolean getSupportsSensitiveDynamicProperties() {
        return this.supportsSensitiveDynamicProperties;
    }

    public void setSupportsSensitiveDynamicProperties(Boolean supportsSensitiveDynamicProperties) {
        this.supportsSensitiveDynamicProperties = supportsSensitiveDynamicProperties;
    }

    @Schema(description="Whether the processor persists state.")
    public Boolean getPersistsState() {
        return this.persistsState;
    }

    public void setPersistsState(Boolean persistsState) {
        this.persistsState = persistsState;
    }

    @Schema(description="Whether the processor has multiple versions available.")
    public Boolean getMultipleVersionsAvailable() {
        return this.multipleVersionsAvailable;
    }

    public void setMultipleVersionsAvailable(Boolean multipleVersionsAvailable) {
        this.multipleVersionsAvailable = multipleVersionsAvailable;
    }

    @Schema(description="Whether the underlying extension is missing.")
    public Boolean getExtensionMissing() {
        return this.isExtensionMissing;
    }

    public void setExtensionMissing(Boolean extensionMissing) {
        this.isExtensionMissing = extensionMissing;
    }

    @Schema(description="Whether the processor requires elevated privileges.")
    public Boolean getRestricted() {
        return this.restricted;
    }

    public void setRestricted(Boolean restricted) {
        this.restricted = restricted;
    }

    @Schema(description="Whether the processor has been deprecated.")
    public Boolean getDeprecated() {
        return this.deprecated;
    }

    public void setDeprecated(Boolean deprecated) {
        this.deprecated = deprecated;
    }

    @Schema(description="The input requirement for this processor.")
    public String getInputRequirement() {
        return this.inputRequirement;
    }

    public void setInputRequirement(String inputRequirement) {
        this.inputRequirement = inputRequirement;
    }

    @Schema(description="The physical state of the processor, including transition states", allowableValues={"RUNNING", "STOPPED", "DISABLED", "STARTING", "STOPPING", "RUN_ONCE"})
    public String getPhysicalState() {
        return this.physicalState;
    }

    public void setPhysicalState(String physicalState) {
        this.physicalState = physicalState;
    }

    @Schema(description="Whether the processor supports batching. This makes the run duration settings available.")
    public Boolean getSupportsBatching() {
        return this.supportsBatching;
    }

    public void setSupportsBatching(Boolean supportsBatching) {
        this.supportsBatching = supportsBatching;
    }

    @Schema(description="The available relationships that the processor currently supports.", accessMode=Schema.AccessMode.READ_ONLY)
    public List<RelationshipDTO> getRelationships() {
        return this.relationships;
    }

    public void setRelationships(List<RelationshipDTO> relationships) {
        this.relationships = relationships;
    }

    @Schema(description="The configuration details for the processor. These details will be included in a response if the verbose flag is included in a request.")
    public ProcessorConfigDTO getConfig() {
        return this.config;
    }

    public void setConfig(ProcessorConfigDTO config) {
        this.config = config;
    }

    @Schema(description="The validation errors for the processor. These validation errors represent the problems with the processor that must be resolved before it can be started.")
    public Collection<String> getValidationErrors() {
        return this.validationErrors;
    }

    public void setValidationErrors(Collection<String> validationErrors) {
        this.validationErrors = validationErrors;
    }

    @Schema(description="Indicates whether the Processor is valid, invalid, or still in the process of validating (i.e., it is unknown whether or not the Processor is valid)", accessMode=Schema.AccessMode.READ_ONLY, allowableValues={"VALID", "INVALID", "VALIDATING"})
    public String getValidationStatus() {
        return this.validationStatus;
    }

    public void setValidationStatus(String validationStatus) {
        this.validationStatus = validationStatus;
    }

    @Schema(description="The description of the processor.")
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    @Schema(description="Indicates if the execution node of a processor is restricted to run only on the primary node")
    public Boolean isExecutionNodeRestricted() {
        return this.executionNodeRestricted;
    }

    public void setExecutionNodeRestricted(Boolean executionNodeRestricted) {
        this.executionNodeRestricted = executionNodeRestricted;
    }
}

