/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.jackson.internal;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.glassfish.jersey.jackson.internal.jackson.jaxrs.base.ProviderBase;
import org.glassfish.jersey.jackson.internal.jackson.jaxrs.cfg.JaxRSFeature;

public class JaxrsFeatureBag<T extends JaxrsFeatureBag> {
    protected static final String JAXRS_FEATURE = "jersey.config.jackson.jaxrs.feature";
    private Optional<List<JaxRSFeatureState>> jaxRSFeature = Optional.empty();

    public T jaxrsFeature(JaxRSFeature feature, boolean state) {
        if (!this.jaxRSFeature.isPresent()) {
            this.jaxRSFeature = Optional.of(new ArrayList());
        }
        this.jaxRSFeature.ifPresent(list -> list.add(new JaxRSFeatureState(feature, state)));
        return (T)this;
    }

    protected boolean hasJaxrsFeature() {
        return this.jaxRSFeature.isPresent();
    }

    void configureJaxrsFeatures(ProviderBase providerBase) {
        this.jaxRSFeature.ifPresent(list -> list.stream().forEach(state -> providerBase.configure(state.feature, state.state)));
    }

    private static class JaxRSFeatureState {
        final JaxRSFeature feature;
        final boolean state;

        public JaxRSFeatureState(JaxRSFeature feature, boolean state) {
            this.feature = feature;
            this.state = state;
        }
    }
}

