/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.registry.security.authorization.util;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.apache.nifi.registry.security.authorization.AuthorizerConfigurationContext;
import org.apache.nifi.registry.security.authorization.Group;
import org.apache.nifi.registry.security.authorization.User;
import org.apache.nifi.registry.security.identity.IdentityMapper;

public final class UserGroupProviderUtils {
    public static final String PROP_INITIAL_USER_IDENTITY_PREFIX = "Initial User Identity ";
    public static final Pattern INITIAL_USER_IDENTITY_PATTERN = Pattern.compile("Initial User Identity \\S+");

    public static Set<String> getInitialUserIdentities(AuthorizerConfigurationContext configurationContext, IdentityMapper identityMapper) {
        HashSet<String> initialUserIdentities = new HashSet<String>();
        for (Map.Entry entry : configurationContext.getProperties().entrySet()) {
            Matcher matcher = INITIAL_USER_IDENTITY_PATTERN.matcher((CharSequence)entry.getKey());
            if (!matcher.matches() || StringUtils.isBlank((CharSequence)((CharSequence)entry.getValue()))) continue;
            initialUserIdentities.add(identityMapper.mapUser((String)entry.getValue()));
        }
        return initialUserIdentities;
    }

    public static Map<String, User> createUserByIdMap(Set<User> users) {
        HashMap<String, User> usersMap = new HashMap<String, User>();
        for (User user : users) {
            usersMap.put(user.getIdentifier(), user);
        }
        return usersMap;
    }

    public static Map<String, User> createUserByIdentityMap(Set<User> users) {
        HashMap<String, User> usersMap = new HashMap<String, User>();
        for (User user : users) {
            usersMap.put(user.getIdentity(), user);
        }
        return usersMap;
    }

    public static Map<String, Group> createGroupByIdMap(Set<Group> groups) {
        HashMap<String, Group> groupsMap = new HashMap<String, Group>();
        for (Group group : groups) {
            groupsMap.put(group.getIdentifier(), group);
        }
        return groupsMap;
    }

    public static Map<String, Set<Group>> createGroupsByUserIdentityMap(Set<Group> groups, Set<User> users) {
        HashMap<String, Set<Group>> groupsByUserIdentity = new HashMap<String, Set<Group>>();
        for (User user : users) {
            HashSet<Group> userGroups = new HashSet<Group>();
            for (Group group : groups) {
                for (String groupUser : group.getUsers()) {
                    if (!groupUser.equals(user.getIdentifier())) continue;
                    userGroups.add(group);
                }
            }
            groupsByUserIdentity.put(user.getIdentity(), userGroups);
        }
        return groupsByUserIdentity;
    }

    private UserGroupProviderUtils() {
    }
}

