/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.components.listen;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.apache.nifi.components.listen.ListenPort;
import org.apache.nifi.components.listen.TransportProtocol;

public class StandardListenPort
implements ListenPort {
    private final String portName;
    private final int portNumber;
    private final TransportProtocol transportProtocol;
    private final List<String> applicationProtocols;

    private StandardListenPort(Builder builder) {
        Objects.requireNonNull(builder.portName, "Port name is required");
        Objects.requireNonNull(builder.transportProtocol, "Transport protocol is required");
        Objects.requireNonNull(builder.applicationProtocols, "Application protocols is required. Use empty list if there are no application protocols.");
        this.portName = builder.portName;
        this.portNumber = builder.portNumber;
        this.transportProtocol = builder.transportProtocol;
        this.applicationProtocols = builder.applicationProtocols;
    }

    @Override
    public int getPortNumber() {
        return this.portNumber;
    }

    @Override
    public String getPortName() {
        return this.portName;
    }

    @Override
    public TransportProtocol getTransportProtocol() {
        return this.transportProtocol;
    }

    @Override
    public List<String> getApplicationProtocols() {
        return this.applicationProtocols;
    }

    public String toString() {
        return "StandardListenPort[portName=%s, portNumber=%s, transportProtocol=%s, applicationProtocols=%s]".formatted(new Object[]{this.portName, this.portNumber, this.transportProtocol, this.applicationProtocols});
    }

    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StandardListenPort that = (StandardListenPort)o;
        return this.portNumber == that.portNumber && Objects.equals(this.portName, that.portName) && this.transportProtocol == that.transportProtocol && Objects.equals(this.applicationProtocols, that.applicationProtocols);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.portName, this.portNumber, this.transportProtocol, this.applicationProtocols});
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private String portName;
        private int portNumber;
        private TransportProtocol transportProtocol;
        private List<String> applicationProtocols = Collections.emptyList();

        public Builder portNumber(int portNumber) {
            this.portNumber = portNumber;
            return this;
        }

        public Builder portName(String portName) {
            this.portName = portName;
            return this;
        }

        public Builder transportProtocol(TransportProtocol transportProtocol) {
            this.transportProtocol = transportProtocol;
            return this;
        }

        public Builder applicationProtocols(List<String> applicationProtocols) {
            this.applicationProtocols = applicationProtocols != null ? applicationProtocols : Collections.emptyList();
            return this;
        }

        public StandardListenPort build() {
            return new StandardListenPort(this);
        }
    }
}

