/*
 * Decompiled with CFR 0.152.
 */
package org.apache.vysper.xmpp.modules.extension.xep0220_server_dailback;

import org.apache.vysper.xmpp.addressing.Entity;
import org.apache.vysper.xmpp.addressing.EntityImpl;
import org.apache.vysper.xmpp.modules.extension.xep0220_server_dailback.DialbackIdGenerator;
import org.apache.vysper.xmpp.protocol.ResponseStanzaContainer;
import org.apache.vysper.xmpp.protocol.ResponseStanzaContainerImpl;
import org.apache.vysper.xmpp.protocol.SessionStateHolder;
import org.apache.vysper.xmpp.protocol.StanzaHandler;
import org.apache.vysper.xmpp.server.ServerRuntimeContext;
import org.apache.vysper.xmpp.server.SessionContext;
import org.apache.vysper.xmpp.server.SessionState;
import org.apache.vysper.xmpp.stanza.Stanza;
import org.apache.vysper.xmpp.stanza.StanzaBuilder;

public class DbVerifyHandler
implements StanzaHandler {
    private DialbackIdGenerator dailbackIdGenerator = new DialbackIdGenerator();

    public String getName() {
        return "verify";
    }

    public boolean verify(Stanza stanza) {
        if (stanza == null) {
            return false;
        }
        if (!this.getName().equals(stanza.getName())) {
            return false;
        }
        String namespaceURI = stanza.getNamespaceURI();
        if (namespaceURI == null) {
            return false;
        }
        return namespaceURI.equals("jabber:server:dialback");
    }

    public boolean isSessionRequired() {
        return true;
    }

    public ResponseStanzaContainer execute(Stanza stanza, ServerRuntimeContext serverRuntimeContext, boolean isOutboundStanza, SessionContext sessionContext, SessionStateHolder sessionStateHolder) {
        String type = stanza.getAttributeValue("type");
        String id = stanza.getAttributeValue("id");
        EntityImpl receiving = EntityImpl.parseUnchecked(stanza.getAttributeValue("from"));
        Entity originating = serverRuntimeContext.getServerEnitity();
        if (type == null) {
            String dailbackId = stanza.getInnerText().getText();
            StanzaBuilder builder = new StanzaBuilder("verify", "jabber:server:dialback", "db");
            builder.addAttribute("from", originating.getDomain());
            builder.addAttribute("to", receiving.getDomain());
            builder.addAttribute("id", id);
            if (this.dailbackIdGenerator.verify(dailbackId, receiving, originating, id)) {
                builder.addAttribute("type", "valid");
            } else {
                builder.addAttribute("type", "invalid");
            }
            return new ResponseStanzaContainerImpl((Stanza)builder.build());
        }
        SessionStateHolder dialbackSessionStateHolder = (SessionStateHolder)sessionContext.getAttribute("DIALBACK_SESSION_STATE_HOLDER");
        SessionContext dialbackSessionContext = (SessionContext)sessionContext.getAttribute("DIALBACK_SESSION_CONTEXT");
        Entity otherServer = sessionContext.getInitiatingEntity();
        String resultType = "invalid";
        if ("valid".equals(type)) {
            dialbackSessionStateHolder.setState(SessionState.AUTHENTICATED);
            dialbackSessionContext.setInitiatingEntity(otherServer);
            resultType = "valid";
        }
        StanzaBuilder builder = new StanzaBuilder("result", "jabber:server:dialback", "db");
        builder.addAttribute("from", originating.getDomain());
        builder.addAttribute("to", otherServer.getDomain());
        builder.addAttribute("type", resultType);
        dialbackSessionContext.getResponseWriter().write((Stanza)builder.build());
        sessionContext.endSession(SessionContext.SessionTerminationCause.CLIENT_BYEBYE);
        return null;
    }
}

