/*
 * Decompiled with CFR 0.152.
 */
package org.apache.vysper.xmpp.modules.extension.xep0054_vcardtemp;

import org.apache.vysper.xml.fragment.Renderer;
import org.apache.vysper.xml.fragment.XMLElement;
import org.apache.vysper.xml.fragment.XMLSemanticError;
import org.apache.vysper.xmpp.addressing.Entity;
import org.apache.vysper.xmpp.modules.core.base.handler.DefaultIQHandler;
import org.apache.vysper.xmpp.modules.extension.xep0054_vcardtemp.VcardTempPersistenceManager;
import org.apache.vysper.xmpp.server.ServerRuntimeContext;
import org.apache.vysper.xmpp.server.SessionContext;
import org.apache.vysper.xmpp.server.response.ServerErrorResponses;
import org.apache.vysper.xmpp.stanza.IQStanza;
import org.apache.vysper.xmpp.stanza.IQStanzaType;
import org.apache.vysper.xmpp.stanza.Stanza;
import org.apache.vysper.xmpp.stanza.StanzaBuilder;
import org.apache.vysper.xmpp.stanza.StanzaErrorCondition;
import org.apache.vysper.xmpp.stanza.StanzaErrorType;

public class VcardTempIQHandler
extends DefaultIQHandler {
    protected boolean returnEmptyVCardWhenNonExistent = true;
    protected VcardTempPersistenceManager persistenceManager;

    public void setPersistenceManager(VcardTempPersistenceManager persistenceManager) {
        this.persistenceManager = persistenceManager;
    }

    protected boolean verifyNamespace(Stanza stanza) {
        return this.verifyInnerNamespace(stanza, "vcard-temp");
    }

    protected boolean verifyInnerElement(Stanza stanza) {
        return this.verifyInnerElementWorker(stanza, "vCard");
    }

    protected Stanza handleSet(IQStanza stanza, ServerRuntimeContext serverRuntimeContext, SessionContext sessionContext) {
        Entity from = stanza.getFrom();
        if (from == null) {
            from = sessionContext.getInitiatingEntity();
        }
        XMLElement vCardElement = null;
        try {
            vCardElement = stanza.getSingleInnerElementsNamed("vCard");
        }
        catch (XMLSemanticError xmlSemanticError) {
            return ServerErrorResponses.getStanzaError(StanzaErrorCondition.BAD_REQUEST, stanza, StanzaErrorType.MODIFY, "vCard element is missing", null, null);
        }
        String vcardContent = new Renderer(vCardElement).getComplete();
        if (this.persistenceManager == null) {
            return ServerErrorResponses.getStanzaError(StanzaErrorCondition.INTERNAL_SERVER_ERROR, stanza, StanzaErrorType.WAIT, "internal storage inaccessible", null, null);
        }
        boolean success = this.persistenceManager.setVcard(from, vcardContent);
        if (success) {
            return (Stanza)StanzaBuilder.createIQStanza(null, from, IQStanzaType.RESULT, stanza.getID()).build();
        }
        return (Stanza)StanzaBuilder.createIQStanza(null, from, IQStanzaType.ERROR, stanza.getID()).build();
    }

    protected Stanza handleGet(IQStanza stanza, ServerRuntimeContext serverRuntimeContext, SessionContext sessionContext) {
        Entity to = stanza.getTo();
        Entity from = stanza.getFrom();
        if (from == null) {
            from = sessionContext.getInitiatingEntity();
        }
        Entity requestedCard = to != null ? to.getBareJID() : from.getBareJID();
        String vcardXml = null;
        if (this.persistenceManager != null) {
            vcardXml = this.persistenceManager.getVcard(requestedCard);
        }
        if (vcardXml == null) {
            IQStanzaType iqStanzaType = this.returnEmptyVCardWhenNonExistent ? IQStanzaType.RESULT : IQStanzaType.ERROR;
            StanzaBuilder stanzaBuilder = StanzaBuilder.createIQStanza(stanza.getTo(), stanza.getFrom(), iqStanzaType, stanza.getID());
            ((StanzaBuilder)stanzaBuilder.startInnerElement("vCard", "vcard-temp")).endInnerElement();
            if (!this.returnEmptyVCardWhenNonExistent) {
                ((StanzaBuilder)((StanzaBuilder)((StanzaBuilder)((StanzaBuilder)stanzaBuilder.startInnerElement("error", "jabber:client")).addAttribute("type", "cancel")).startInnerElement("item-not-found", "urn:ietf:params:xml:ns:xmpp-stanzas")).endInnerElement()).endInnerElement();
            }
            return (Stanza)stanzaBuilder.build();
        }
        StanzaBuilder stanzaBuilder = StanzaBuilder.createIQStanza(stanza.getTo(), stanza.getFrom(), IQStanzaType.RESULT, stanza.getID());
        stanzaBuilder.addText(vcardXml);
        return (Stanza)stanzaBuilder.build();
    }
}

