/*
 * Decompiled with CFR 0.152.
 */
package org.apache.vysper.xmpp.modules.core.base.handler;

import java.util.List;
import org.apache.vysper.xml.fragment.XMLElement;
import org.apache.vysper.xml.fragment.XMLElementVerifier;
import org.apache.vysper.xmpp.modules.core.base.handler.XMPPCoreStanzaHandler;
import org.apache.vysper.xmpp.server.ServerRuntimeContext;
import org.apache.vysper.xmpp.server.SessionContext;
import org.apache.vysper.xmpp.server.response.ServerErrorResponses;
import org.apache.vysper.xmpp.stanza.IQStanza;
import org.apache.vysper.xmpp.stanza.IQStanzaType;
import org.apache.vysper.xmpp.stanza.Stanza;
import org.apache.vysper.xmpp.stanza.StanzaErrorCondition;
import org.apache.vysper.xmpp.stanza.StanzaErrorType;
import org.apache.vysper.xmpp.stanza.XMPPCoreStanza;

public class IQHandler
extends XMPPCoreStanzaHandler {
    public String getName() {
        return "iq";
    }

    protected boolean verifyType(Stanza stanza) {
        return IQStanza.isOfType(stanza);
    }

    protected boolean verifyInnerNamespace(Stanza stanza, String namespace) {
        XMLElementVerifier xmlElementVerifier = stanza.getVerifier();
        if (!xmlElementVerifier.subElementsPresentAtLeast(1)) {
            return false;
        }
        List innerElements = stanza.getInnerElements();
        XMLElement firstInnerElement = (XMLElement)innerElements.get(0);
        return firstInnerElement.getNamespaceURI().equals(namespace);
    }

    protected Stanza executeCore(XMPPCoreStanza coreStanza, ServerRuntimeContext serverRuntimeContext, boolean isOutboundStanza, SessionContext sessionContext) {
        IQStanza stanza = (IQStanza)coreStanza;
        String id = stanza.getID();
        if (id == null) {
            return ServerErrorResponses.getStanzaError(StanzaErrorCondition.BAD_REQUEST, stanza, StanzaErrorType.MODIFY, "iq-stanza requires 'id' attribute to be present", this.getErrorLanguage(serverRuntimeContext, sessionContext), null);
        }
        IQStanzaType iqType = stanza.getIQType();
        if (iqType == null) {
            return ServerErrorResponses.getStanzaError(StanzaErrorCondition.BAD_REQUEST, stanza, StanzaErrorType.MODIFY, "iq-stanza requires a valid 'type' attribute to be present", this.getErrorLanguage(serverRuntimeContext, sessionContext), null);
        }
        if (iqType == IQStanzaType.GET || iqType == IQStanzaType.SET) {
            if (!coreStanza.getVerifier().subElementsPresentExact(1)) {
                return ServerErrorResponses.getStanzaError(StanzaErrorCondition.BAD_REQUEST, stanza, StanzaErrorType.MODIFY, "iq stanza of type get or set require exactly one child", this.getErrorLanguage(serverRuntimeContext, sessionContext), null);
            }
        } else if (iqType == IQStanzaType.RESULT) {
            if (!coreStanza.getVerifier().subElementsPresentAtMost(1)) {
                return ServerErrorResponses.getStanzaError(StanzaErrorCondition.BAD_REQUEST, stanza, StanzaErrorType.MODIFY, "iq stanza of type result may not have more than one child", this.getErrorLanguage(serverRuntimeContext, sessionContext), null);
            }
        } else if (iqType == IQStanzaType.ERROR) {
            // empty if block
        }
        return this.executeIQLogic(stanza, serverRuntimeContext, isOutboundStanza, sessionContext);
    }

    protected String getErrorLanguage(ServerRuntimeContext serverRuntimeContext, SessionContext sessionContext) {
        if (sessionContext != null) {
            return sessionContext.getXMLLang();
        }
        return serverRuntimeContext.getDefaultXMLLang();
    }

    protected Stanza executeIQLogic(IQStanza stanza, ServerRuntimeContext serverRuntimeContext, boolean outboundStanza, SessionContext sessionContext) {
        return ServerErrorResponses.getStanzaError(StanzaErrorCondition.FEATURE_NOT_IMPLEMENTED, stanza, StanzaErrorType.CANCEL, null, null, null);
    }
}

