/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.di.impl;

import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.maven.di.impl.Dependency;

public abstract class BindingInitializer<T> {
    private final Set<Dependency<?>> dependencies;

    protected BindingInitializer(Set<Dependency<?>> dependencies) {
        this.dependencies = dependencies;
    }

    public Set<Dependency<?>> getDependencies() {
        return this.dependencies;
    }

    public abstract Consumer<T> compile(Function<Dependency<?>, Supplier<?>> var1);

    public static <T> BindingInitializer<T> combine(final List<BindingInitializer<T>> bindingInitializers) {
        Set deps = bindingInitializers.stream().map(BindingInitializer::getDependencies).flatMap(Collection::stream).collect(Collectors.toSet());
        return new BindingInitializer<T>(deps){

            @Override
            public Consumer<T> compile(Function<Dependency<?>, Supplier<?>> compiler) {
                return instance -> bindingInitializers.stream().map(bindingInitializer -> bindingInitializer.compile(compiler)).forEach(i -> i.accept(instance));
            }
        };
    }
}

