/*
 * Decompiled with CFR 0.152.
 */
package tdb2.xloader;

import java.util.Arrays;
import java.util.Objects;
import org.apache.jena.atlas.lib.FileOps;
import org.apache.jena.cmd.ArgDecl;
import org.apache.jena.cmd.CmdException;
import org.apache.jena.dboe.base.file.Location;
import org.apache.jena.riot.Lang;
import org.apache.jena.riot.RDFLanguages;
import org.apache.jena.tdb2.xloader.ProcIngestDataX;
import tdb2.xloader.AbstractCmdxLoad;

public class CmdxIngestData
extends AbstractCmdxLoad {
    private static ArgDecl argTriplesOut = new ArgDecl(true, "triples");
    private static ArgDecl argQuadsOut = new ArgDecl(true, "quads");
    private String dataFileTriples;
    private String dataFileQuads;
    private boolean collectStats = false;

    public static void main(String ... args) {
        new CmdxIngestData(args).mainRun();
    }

    protected CmdxIngestData(String[] argv) {
        super("Data", argv);
        super.add(argTriplesOut);
        super.add(argQuadsOut);
    }

    @Override
    protected void setCmdArgs() {
        super.add(argLocation, "--loc=", "Database location");
        super.add(argTmpdir, "--tmpdir=", "Temporary directory (defaults to --loc)");
    }

    @Override
    protected String getCommandName() {
        return this.getClass().getCanonicalName();
    }

    @Override
    protected String getSummary() {
        return this.getCommandName() + " " + this.getArgsSummary();
    }

    @Override
    protected String getArgsSummary() {
        return super.getArgsSummary();
    }

    @Override
    protected void subCheckArgs() {
    }

    @Override
    protected void processModulesAndArgs() {
        if (!super.contains(argLocation)) {
            throw new CmdException("Required: --loc DIR");
        }
        super.processModulesAndArgs();
        Location tmp = Location.create(this.tmpdir);
        this.dataFileTriples = super.getValue(argTriplesOut);
        if (this.dataFileTriples == null) {
            this.dataFileTriples = tmp.getPath("triples", "tmp");
        }
        this.dataFileQuads = super.getValue(argQuadsOut);
        if (this.dataFileQuads == null) {
            this.dataFileQuads = tmp.getPath("quads", "tmp");
        }
        if (Objects.equals(this.dataFileTriples, this.dataFileQuads)) {
            this.cmdError("Triples and Quads work files are the same");
        }
        if (this.filenames.isEmpty()) {
            this.filenames = Arrays.asList("-");
        }
        for (String filename : this.filenames) {
            Lang lang = RDFLanguages.filenameToLang(filename, RDFLanguages.NQUADS);
            if (lang == null) {
                this.cmdError("File suffix not recognized: " + filename);
            }
            if (filename.equals("-") || FileOps.exists(filename)) continue;
            this.cmdError("File does not exist: " + filename);
        }
    }

    @Override
    protected void exec() {
        ProcIngestDataX.exec(this.location, this.loaderFiles, this.filenames, this.collectStats);
    }
}

