/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.system;

import java.util.Objects;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.Semaphore;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.jena.atlas.logging.Log;

public class ThreadAction {
    private final Semaphore semaStart = new Semaphore(0, true);
    private final Semaphore semaFinish = new Semaphore(0, true);
    private final AtomicReference<RuntimeException> thrownRuntimeException = new AtomicReference<Object>(null);
    private final AtomicReference<Error> thrownError = new AtomicReference<Object>(null);
    private final Runnable action;
    private static Executor executor = Executors.newCachedThreadPool();

    private ThreadAction(Runnable action) {
        this.action = action;
    }

    public void run() {
        this.semaStart.release();
        this.semaFinish.acquireUninterruptibly();
        if (this.thrownError.get() != null) {
            throw this.thrownError.get();
        }
        if (this.thrownRuntimeException.get() != null) {
            throw this.thrownRuntimeException.get();
        }
    }

    private void trigger() {
        try {
            this.action.run();
        }
        catch (Error error) {
            this.thrownError.set(error);
            throw error;
        }
        catch (RuntimeException ex) {
            this.thrownRuntimeException.set(ex);
            throw ex;
        }
    }

    public static ThreadAction create(Runnable action) {
        return ThreadAction.create(null, action, null);
    }

    public static ThreadAction create(Runnable before, Runnable action, Runnable after) {
        Objects.requireNonNull(action);
        ThreadAction threadAction = new ThreadAction(action);
        Semaphore semaCreateStart = new Semaphore(0, true);
        executor.execute(() -> {
            try {
                if (before != null) {
                    before.run();
                }
            }
            catch (Throwable th) {
                Log.warn(ThreadAction.class, "Throwable in 'before' action: " + th.getMessage(), th);
                semaCreateStart.release();
                threadAction.semaFinish.release();
                return;
            }
            semaCreateStart.release();
            threadAction.semaStart.acquireUninterruptibly();
            try {
                threadAction.trigger();
            }
            catch (Throwable th) {
                // empty catch block
            }
            try {
                if (after != null) {
                    after.run();
                }
            }
            catch (Throwable th) {
                Log.warn(ThreadAction.class, "Throwable in 'after' action: " + th.getMessage(), th);
            }
            threadAction.semaFinish.release();
        });
        semaCreateStart.acquireUninterruptibly();
        return threadAction;
    }
}

