/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.function;

import java.util.List;
import org.apache.jena.atlas.lib.Lib;
import org.apache.jena.query.QueryBuildException;
import org.apache.jena.sparql.ARQInternalErrorException;
import org.apache.jena.sparql.expr.ExprEvalException;
import org.apache.jena.sparql.expr.ExprList;
import org.apache.jena.sparql.expr.NodeValue;
import org.apache.jena.sparql.function.FunctionBase;

public abstract class FunctionBase4
extends FunctionBase {
    @Override
    public void checkBuild(String uri, ExprList args) {
        if (args.size() != 4) {
            throw new QueryBuildException("Function '" + Lib.className(this) + "' takes four arguments");
        }
    }

    @Override
    public final NodeValue exec(List<NodeValue> args) {
        if (args == null) {
            throw new ARQInternalErrorException(Lib.className(this) + ": Null args list");
        }
        if (args.size() != 4) {
            throw new ExprEvalException(Lib.className(this) + ": Wrong number of arguments: Wanted 4, got " + args.size());
        }
        NodeValue v1 = args.get(0);
        NodeValue v2 = args.get(1);
        NodeValue v3 = args.get(2);
        NodeValue v4 = args.get(3);
        return this.exec(v1, v2, v3, v4);
    }

    public abstract NodeValue exec(NodeValue var1, NodeValue var2, NodeValue var3, NodeValue var4);
}

