/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.util;

import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.EnumMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class VersionInfo {
    static final Logger LOG = LoggerFactory.getLogger(VersionInfo.class);
    private static final String RATIS_VERSION_PROPERTIES = "ratis-version.properties";
    private static final String UNKNOWN = "<unknown>";
    private static final String FORMAT = "  %20s: %s";
    private final Class<?> clazz;
    private final InfoMap<RuntimeInfo> runtimeInfos = RuntimeInfo.MAP;
    private final InfoMap<SoftwareInfo> softwareInfos;
    private final Map<String, String> otherInfos;

    public static VersionInfo load(Class<?> clazz) {
        Properties properties = new Properties();
        try (InputStream in = clazz.getClassLoader().getResourceAsStream(RATIS_VERSION_PROPERTIES);){
            if (in != null) {
                properties.load(in);
            } else {
                LOG.warn("Resource '{}' not found for {}", (Object)RATIS_VERSION_PROPERTIES, clazz);
            }
        }
        catch (IOException e) {
            LOG.warn("Failed to load resource '{}' for {}", new Object[]{RATIS_VERSION_PROPERTIES, clazz, e});
        }
        return new VersionInfo(clazz, properties);
    }

    private VersionInfo(Class<?> clazz, Properties properties) {
        this.clazz = Objects.requireNonNull(clazz, "clazz == null");
        EnumMap<SoftwareInfo, String> softwareInfoMap = new EnumMap<SoftwareInfo, String>(SoftwareInfo.class);
        LinkedHashMap<String, String> others = new LinkedHashMap<String, String>();
        for (Map.Entry<Object, Object> e : properties.entrySet()) {
            String key = e.getKey().toString();
            String value = e.getValue().toString();
            SoftwareInfo k = SoftwareInfo.parse(key);
            if (k != null) {
                softwareInfoMap.put(k, value);
                continue;
            }
            others.put(key, value);
        }
        this.softwareInfos = new InfoMap<SoftwareInfo>(softwareInfoMap);
        this.otherInfos = Collections.unmodifiableMap(others);
    }

    public void printStartupMessages(Object name, Consumer<String> log) {
        Objects.requireNonNull(name, "name == null");
        log.accept(String.format("Starting %s -- %s %s", this.softwareInfos.getOrDefault(SoftwareInfo.NAME), this.clazz.getSimpleName(), name));
        SoftwareInfo[] softwareInfoValues = SoftwareInfo.values();
        for (int i = 1; i < softwareInfoValues.length; ++i) {
            log.accept(this.softwareInfos.format(softwareInfoValues[i]));
        }
        for (RuntimeInfo runtimeInfo : RuntimeInfo.values()) {
            log.accept(this.runtimeInfos.format(runtimeInfo));
        }
        for (Map.Entry entry : this.otherInfos.entrySet()) {
            log.accept(String.format(FORMAT, entry.getKey(), entry.getValue()));
        }
    }

    public static void main(String[] args) {
        VersionInfo.load(VersionInfo.class).printStartupMessages(":", System.out::println);
    }

    private static class InfoMap<INFO extends Enum<INFO>> {
        private final Map<INFO, String> map;

        InfoMap(EnumMap<INFO, String> map) {
            this.map = Collections.unmodifiableMap(map);
        }

        String getOrDefault(INFO info) {
            return this.map.getOrDefault(info, VersionInfo.UNKNOWN);
        }

        String format(INFO info) {
            return String.format(VersionInfo.FORMAT, ((Enum)info).name().toLowerCase(), this.getOrDefault(info));
        }
    }

    private static enum RuntimeInfo {
        JAVA,
        USER;

        static final InfoMap<RuntimeInfo> MAP;

        static {
            EnumMap<RuntimeInfo, String> map = new EnumMap<RuntimeInfo, String>(RuntimeInfo.class);
            Properties properties = System.getProperties();
            map.put(JAVA, properties.getProperty("java.vm.name") + " " + properties.getProperty("java.runtime.version"));
            map.put(USER, properties.getProperty("user.name"));
            MAP = new InfoMap<RuntimeInfo>(map);
        }
    }

    private static enum SoftwareInfo {
        NAME,
        VERSION,
        URL,
        REVISION;


        static SoftwareInfo parse(String key) {
            for (SoftwareInfo info : SoftwareInfo.values()) {
                if (!info.name().toLowerCase().equals(key)) continue;
                return info;
            }
            return null;
        }
    }
}

