/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.pipe.agent.runtime;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.commons.io.FileUtils;
import org.apache.iotdb.commons.consensus.index.ProgressIndex;
import org.apache.iotdb.commons.consensus.index.impl.SimpleProgressIndex;
import org.apache.iotdb.commons.file.SystemFileFactory;
import org.apache.iotdb.db.conf.IoTDBConfig;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.write.InsertNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleProgressIndexAssigner {
    private static final Logger LOGGER = LoggerFactory.getLogger(SimpleProgressIndexAssigner.class);
    private static final IoTDBConfig IOTDB_CONFIG = IoTDBDescriptor.getInstance().getConfig();
    private static final String PIPE_SYSTEM_DIR = IoTDBDescriptor.getInstance().getConfig().getSystemDir() + File.separator + "pipe" + File.separator;
    private static final String REBOOT_TIMES_FILE_NAME = "reboot_times.txt";
    private boolean isSimpleConsensusEnable = false;
    private int rebootTimes = 0;
    private final AtomicLong insertionRequestId = new AtomicLong(1L);

    public void start() {
        this.isSimpleConsensusEnable = IOTDB_CONFIG.getDataRegionConsensusProtocolClass().equals("org.apache.iotdb.consensus.simple.SimpleConsensus");
        LOGGER.info("Starting SimpleProgressIndexAssigner ...");
        try {
            this.makeDirIfNecessary();
            this.parseRebootTimes();
            this.recordRebootTimes();
            LOGGER.info("SimpleProgressIndexAssigner started successfully. isSimpleConsensusEnable: {}, rebootTimes: {}", (Object)this.isSimpleConsensusEnable, (Object)this.rebootTimes);
        }
        catch (Exception e) {
            LOGGER.error("Cannot start SimpleProgressIndexAssigner because of {}", (Object)e.getMessage(), (Object)e);
        }
    }

    private void makeDirIfNecessary() throws IOException {
        File file = SystemFileFactory.INSTANCE.getFile(PIPE_SYSTEM_DIR);
        if (file.exists() && file.isDirectory()) {
            return;
        }
        FileUtils.forceMkdir((File)file);
    }

    private void parseRebootTimes() {
        File file = SystemFileFactory.INSTANCE.getFile(PIPE_SYSTEM_DIR + REBOOT_TIMES_FILE_NAME);
        if (!file.exists()) {
            this.rebootTimes = 0;
            return;
        }
        try {
            String content = FileUtils.readFileToString((File)file, (Charset)StandardCharsets.UTF_8);
            this.rebootTimes = Integer.parseInt(content);
        }
        catch (Exception e) {
            this.rebootTimes = (int)(System.currentTimeMillis() / 1000L);
            LOGGER.error("Cannot parse reboot times from file {}, set the current time in seconds ({}) as the reboot times", (Object)file.getAbsolutePath(), (Object)this.rebootTimes);
        }
    }

    private void recordRebootTimes() {
        File file = SystemFileFactory.INSTANCE.getFile(PIPE_SYSTEM_DIR + REBOOT_TIMES_FILE_NAME);
        try (FileOutputStream fos = new FileOutputStream(file, false);){
            fos.write(String.valueOf(this.rebootTimes + 1).getBytes(StandardCharsets.UTF_8));
            fos.flush();
            fos.getFD().sync();
        }
        catch (Exception e) {
            LOGGER.error("Cannot record reboot times {} to file {}, the reboot times will not be updated", (Object)this.rebootTimes, (Object)file.getAbsolutePath());
        }
    }

    public void assignIfNeeded(InsertNode insertNode) {
        if (!this.isSimpleConsensusEnable) {
            return;
        }
        insertNode.setProgressIndex((ProgressIndex)new SimpleProgressIndex(this.rebootTimes, this.insertionRequestId.getAndIncrement()));
    }

    public SimpleProgressIndex getSimpleProgressIndex() {
        return new SimpleProgressIndex(this.rebootTimes, this.insertionRequestId.getAndIncrement());
    }

    public int getRebootTimes() {
        return this.rebootTimes;
    }
}

