/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tsfile.file.metadata;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import org.apache.tsfile.common.conf.TSFileConfig;
import org.apache.tsfile.common.conf.TSFileDescriptor;
import org.apache.tsfile.compatibility.DeserializeConfig;
import org.apache.tsfile.file.IMetadataIndexEntry;
import org.apache.tsfile.file.metadata.enums.MetadataIndexNodeType;
import org.apache.tsfile.utils.Pair;
import org.apache.tsfile.utils.ReadWriteForEncodingUtils;
import org.apache.tsfile.utils.ReadWriteIOUtils;

public class MetadataIndexNode {
    protected static final TSFileConfig config = TSFileDescriptor.getInstance().getConfig();
    protected final List<IMetadataIndexEntry> children;
    protected long endOffset;
    private final MetadataIndexNodeType nodeType;

    public MetadataIndexNode(MetadataIndexNodeType nodeType) {
        this.children = new ArrayList<IMetadataIndexEntry>();
        this.endOffset = -1L;
        this.nodeType = nodeType;
    }

    public MetadataIndexNode(List<IMetadataIndexEntry> children, long endOffset, MetadataIndexNodeType nodeType) {
        this.children = children;
        this.endOffset = endOffset;
        this.nodeType = nodeType;
    }

    public List<IMetadataIndexEntry> getChildren() {
        return this.children;
    }

    public long getEndOffset() {
        return this.endOffset;
    }

    public void setEndOffset(long endOffset) {
        this.endOffset = endOffset;
    }

    public MetadataIndexNodeType getNodeType() {
        return this.nodeType;
    }

    public void addEntry(IMetadataIndexEntry metadataIndexEntry) {
        this.children.add(metadataIndexEntry);
    }

    public boolean isFull() {
        return this.children.size() >= config.getMaxDegreeOfIndexNode();
    }

    IMetadataIndexEntry peek() {
        if (this.children.isEmpty()) {
            return null;
        }
        return this.children.get(0);
    }

    public int serializeTo(OutputStream outputStream) throws IOException {
        int byteLen = 0;
        byteLen += ReadWriteForEncodingUtils.writeUnsignedVarInt(this.children.size(), outputStream);
        for (IMetadataIndexEntry metadataIndexEntry : this.children) {
            byteLen += metadataIndexEntry.serializeTo(outputStream);
        }
        byteLen += ReadWriteIOUtils.write(this.endOffset, outputStream);
        return byteLen += ReadWriteIOUtils.write(this.nodeType.serialize(), outputStream);
    }

    public static MetadataIndexNode deserializeFrom(ByteBuffer buffer, boolean isDeviceLevel, DeserializeConfig context) {
        ArrayList<IMetadataIndexEntry> children = new ArrayList<IMetadataIndexEntry>();
        int size = ReadWriteForEncodingUtils.readUnsignedVarInt(buffer);
        for (int i = 0; i < size; ++i) {
            children.add(context.deserializeMetadataIndexEntry(buffer, isDeviceLevel));
        }
        long offset = ReadWriteIOUtils.readLong(buffer);
        MetadataIndexNodeType nodeType = MetadataIndexNodeType.deserialize(ReadWriteIOUtils.readByte(buffer));
        return new MetadataIndexNode(children, offset, nodeType);
    }

    public static MetadataIndexNode deserializeFrom(InputStream inputStream, boolean isDeviceLevel, DeserializeConfig config) throws IOException {
        ArrayList<IMetadataIndexEntry> children = new ArrayList<IMetadataIndexEntry>();
        int size = ReadWriteForEncodingUtils.readUnsignedVarInt(inputStream);
        for (int i = 0; i < size; ++i) {
            children.add(config.deserializeMetadataIndexEntry(inputStream, isDeviceLevel));
        }
        long offset = ReadWriteIOUtils.readLong(inputStream);
        MetadataIndexNodeType nodeType = MetadataIndexNodeType.deserialize(ReadWriteIOUtils.readByte(inputStream));
        return new MetadataIndexNode(children, offset, nodeType);
    }

    public Pair<IMetadataIndexEntry, Long> getChildIndexEntry(Comparable key, boolean exactSearch) {
        int index = this.binarySearchInChildren(key, exactSearch);
        if (index == -1) {
            return null;
        }
        long childEndOffset = index != this.children.size() - 1 ? this.children.get(index + 1).getOffset() : this.endOffset;
        return new Pair<IMetadataIndexEntry, Long>(this.children.get(index), childEndOffset);
    }

    int binarySearchInChildren(Comparable key, boolean exactSearch) {
        int low = 0;
        int high = this.children.size() - 1;
        while (low <= high) {
            int mid = low + high >>> 1;
            IMetadataIndexEntry midVal = this.children.get(mid);
            int cmp = midVal.getCompareKey().compareTo(key);
            if (cmp < 0) {
                low = mid + 1;
                continue;
            }
            if (cmp > 0) {
                high = mid - 1;
                continue;
            }
            return mid;
        }
        if (exactSearch) {
            return -1;
        }
        return low == 0 ? low : low - 1;
    }

    public boolean isDeviceLevel() {
        return this.nodeType == MetadataIndexNodeType.INTERNAL_DEVICE || this.nodeType == MetadataIndexNodeType.LEAF_DEVICE;
    }
}

