/*
 * Decompiled with CFR 0.152.
 */
package io.moquette.broker.security;

import io.moquette.broker.security.IAuthorizatorPolicy;
import io.moquette.broker.subscriptions.Topic;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

public class DeclarativeAuthorizatorPolicy
implements IAuthorizatorPolicy {
    private final Set<TopicUserClient> readAdmitted = new HashSet<TopicUserClient>();
    private final Set<TopicUserClient> writeAdmitted = new HashSet<TopicUserClient>();

    protected void addWriteTo(Topic topic, String user, String client) {
        this.writeAdmitted.add(new TopicUserClient(topic, user, client));
    }

    protected void addReadFrom(Topic topic, String user, String client) {
        this.readAdmitted.add(new TopicUserClient(topic, user, client));
    }

    @Override
    public boolean canWrite(Topic topic, String user, String client) {
        return this.writeAdmitted.contains(new TopicUserClient(topic, user, client));
    }

    @Override
    public boolean canRead(Topic topic, String user, String client) {
        return this.readAdmitted.contains(new TopicUserClient(topic, user, client));
    }

    static final class TopicUserClient {
        final Topic topic;
        final String user;
        final String client;

        public TopicUserClient(Topic topic, String user, String client) {
            Objects.requireNonNull(topic);
            user = user == null ? "<>" : user;
            Objects.requireNonNull(client);
            this.topic = topic;
            this.user = user;
            this.client = client;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            TopicUserClient that = (TopicUserClient)o;
            return Objects.equals(this.topic, that.topic) && Objects.equals(this.user, that.user) && Objects.equals(this.client, that.client);
        }

        public int hashCode() {
            return Objects.hash(this.topic, this.user, this.client);
        }
    }

    public static final class Builder {
        private DeclarativeAuthorizatorPolicy instance;

        public Builder readFrom(Topic topic, String user, String client) {
            DeclarativeAuthorizatorPolicy policy = this.createOrGet();
            policy.addReadFrom(topic, user, client);
            return this;
        }

        public Builder writeTo(Topic topic, String user, String client) {
            DeclarativeAuthorizatorPolicy policy = this.createOrGet();
            policy.addWriteTo(topic, user, client);
            return this;
        }

        private DeclarativeAuthorizatorPolicy createOrGet() {
            if (this.instance == null) {
                this.instance = new DeclarativeAuthorizatorPolicy();
            }
            return this.instance;
        }

        public IAuthorizatorPolicy build() {
            return this.createOrGet();
        }
    }
}

