/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.actions;

import java.util.Map;
import org.apache.iceberg.ContentFile;
import org.apache.iceberg.ContentScanTask;
import org.apache.iceberg.StructLike;
import org.apache.iceberg.actions.RewriteGroupBase;
import org.apache.iceberg.io.CloseableIterable;

public class FileRewritePlan<I, T extends ContentScanTask<F>, F extends ContentFile<F>, G extends RewriteGroupBase<I, T, F>> {
    private final CloseableIterable<G> groups;
    private final int totalGroupCount;
    private final Map<StructLike, Integer> groupsInPartition;

    FileRewritePlan(CloseableIterable<G> groups, int totalGroupCount, Map<StructLike, Integer> groupsInPartition) {
        this.groups = groups;
        this.totalGroupCount = totalGroupCount;
        this.groupsInPartition = groupsInPartition;
    }

    public CloseableIterable<G> groups() {
        return this.groups;
    }

    public int groupsInPartition(StructLike partition) {
        return this.groupsInPartition.get(partition);
    }

    public int totalGroupCount() {
        return this.totalGroupCount;
    }
}

