/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudwatchlogs.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.cloudwatchlogs.CloudWatchLogsClient;
import software.amazon.awssdk.services.cloudwatchlogs.internal.UserAgentUtils;
import software.amazon.awssdk.services.cloudwatchlogs.model.DeliveryDestination;
import software.amazon.awssdk.services.cloudwatchlogs.model.DescribeDeliveryDestinationsRequest;
import software.amazon.awssdk.services.cloudwatchlogs.model.DescribeDeliveryDestinationsResponse;

public class DescribeDeliveryDestinationsIterable
implements SdkIterable<DescribeDeliveryDestinationsResponse> {
    private final CloudWatchLogsClient client;
    private final DescribeDeliveryDestinationsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public DescribeDeliveryDestinationsIterable(CloudWatchLogsClient client, DescribeDeliveryDestinationsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new DescribeDeliveryDestinationsResponseFetcher();
    }

    public Iterator<DescribeDeliveryDestinationsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<DeliveryDestination> deliveryDestinations() {
        Function<DescribeDeliveryDestinationsResponse, Iterator> getIterator = response -> {
            if (response != null && response.deliveryDestinations() != null) {
                return response.deliveryDestinations().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class DescribeDeliveryDestinationsResponseFetcher
    implements SyncPageFetcher<DescribeDeliveryDestinationsResponse> {
        private DescribeDeliveryDestinationsResponseFetcher() {
        }

        public boolean hasNextPage(DescribeDeliveryDestinationsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public DescribeDeliveryDestinationsResponse nextPage(DescribeDeliveryDestinationsResponse previousPage) {
            if (previousPage == null) {
                return DescribeDeliveryDestinationsIterable.this.client.describeDeliveryDestinations(DescribeDeliveryDestinationsIterable.this.firstRequest);
            }
            return DescribeDeliveryDestinationsIterable.this.client.describeDeliveryDestinations((DescribeDeliveryDestinationsRequest)((Object)DescribeDeliveryDestinationsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

