/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.awssdk.v2_2.internal;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;

class FieldMapping {
    private final Type type;
    private final String attribute;
    private final List<String> fields;

    static FieldMapping request(String attribute, String fieldPath) {
        return new FieldMapping(Type.REQUEST, attribute, fieldPath);
    }

    static FieldMapping response(String attribute, String fieldPath) {
        return new FieldMapping(Type.RESPONSE, attribute, fieldPath);
    }

    FieldMapping(Type type, String attribute, String fieldPath) {
        this.type = type;
        this.attribute = attribute;
        this.fields = Collections.unmodifiableList(Arrays.asList(fieldPath.split("\\.")));
    }

    String getAttribute() {
        return this.attribute;
    }

    List<String> getFields() {
        return this.fields;
    }

    Type getType() {
        return this.type;
    }

    static Map<Type, List<FieldMapping>> groupByType(FieldMapping[] fieldMappings) {
        EnumMap<Type, List<FieldMapping>> fields = new EnumMap<Type, List<FieldMapping>>(Type.class);
        for (Type type : Type.values()) {
            fields.put(type, new ArrayList());
        }
        for (FieldMapping fieldMapping : fieldMappings) {
            fields.get((Object)fieldMapping.getType()).add(fieldMapping);
        }
        return fields;
    }

    static enum Type {
        REQUEST,
        RESPONSE;

    }
}

