/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.datastructures;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Map;
import java.util.UUID;
import org.apache.ignite.internal.processors.datastructures.DataStructureType;
import org.apache.ignite.internal.processors.datastructures.VolatileAtomicDataStructureValue;
import org.apache.ignite.internal.util.tostring.GridToStringInclude;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.jetbrains.annotations.Nullable;

public class GridCacheSemaphoreState
extends VolatileAtomicDataStructureValue
implements Cloneable {
    private static final long serialVersionUID = 0L;
    private int cnt;
    @GridToStringInclude
    private Map<UUID, Integer> waiters;
    private boolean failoverSafe;
    private boolean broken;
    private long gridStartTime;

    public GridCacheSemaphoreState(int cnt, @Nullable Map<UUID, Integer> waiters, boolean failoverSafe, long gridStartTime) {
        this.cnt = cnt;
        this.waiters = waiters;
        this.failoverSafe = failoverSafe;
        this.gridStartTime = gridStartTime;
    }

    public GridCacheSemaphoreState() {
    }

    @Override
    public DataStructureType type() {
        return DataStructureType.SEMAPHORE;
    }

    @Override
    public long gridStartTime() {
        return this.gridStartTime;
    }

    public void setCount(int cnt) {
        this.cnt = cnt;
    }

    public int getCount() {
        return this.cnt;
    }

    public Map<UUID, Integer> getWaiters() {
        return this.waiters;
    }

    public void setWaiters(Map<UUID, Integer> waiters) {
        this.waiters = waiters;
    }

    public boolean isFailoverSafe() {
        return this.failoverSafe;
    }

    public boolean isBroken() {
        return this.broken;
    }

    public void setBroken(boolean broken) {
        this.broken = broken;
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeInt(this.cnt);
        out.writeBoolean(this.failoverSafe);
        out.writeLong(this.gridStartTime);
        out.writeBoolean(this.waiters != null);
        if (this.waiters != null) {
            out.writeInt(this.waiters.size());
            for (Map.Entry<UUID, Integer> e : this.waiters.entrySet()) {
                U.writeUuid(out, e.getKey());
                out.writeInt(e.getValue());
            }
        }
        out.writeBoolean(this.broken);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException {
        this.cnt = in.readInt();
        this.failoverSafe = in.readBoolean();
        this.gridStartTime = in.readLong();
        if (in.readBoolean()) {
            int size = in.readInt();
            this.waiters = U.newHashMap(size);
            for (int i = 0; i < size; ++i) {
                this.waiters.put(U.readUuid(in), in.readInt());
            }
        }
        this.broken = in.readBoolean();
    }

    public String toString() {
        return S.toString(GridCacheSemaphoreState.class, this);
    }
}

