/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.security.authentication;

import io.micronaut.context.condition.Condition;
import io.micronaut.context.condition.ConditionContext;
import io.micronaut.core.value.PropertyResolver;
import io.micronaut.security.authentication.AuthenticationMode;
import java.util.List;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AuthenticationModeCondition
implements Condition {
    private static final Logger LOG = LoggerFactory.getLogger(AuthenticationModeCondition.class);
    private final List<AuthenticationMode> acceptableModes;

    public AuthenticationModeCondition(List<AuthenticationMode> acceptableModes) {
        this.acceptableModes = acceptableModes;
    }

    public boolean matches(ConditionContext context) {
        PropertyResolver propertyResolver = (PropertyResolver)context.getBeanContext().getBean(PropertyResolver.class);
        String propertyName = "micronaut.security.authentication";
        if (!propertyResolver.containsProperty("micronaut.security.authentication")) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("{}} is not fulfilled because {} is not set.", (Object)this.getClass().getSimpleName(), (Object)"micronaut.security.authentication");
            }
            return false;
        }
        Optional propertyValueOptional = propertyResolver.get((CharSequence)"micronaut.security.authentication", String.class);
        if (!propertyValueOptional.isPresent()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("{} is not fulfilled because {} property is not a String.", (Object)this.getClass().getSimpleName(), (Object)"micronaut.security.authentication");
            }
            return false;
        }
        String propertyvalue = (String)propertyValueOptional.get();
        boolean result = this.acceptableModes.stream().map(AuthenticationMode::toString).anyMatch(propertyvalue::equals);
        if (!result && LOG.isDebugEnabled()) {
            LOG.debug("{} is not fulfilled because {} is not one of {}.", new Object[]{this.getClass().getSimpleName(), "micronaut.security.authentication", this.acceptableModes});
        }
        return result;
    }
}

